<?php
include_once 'config-data.php';
?>
<div class="modal fade" id="kt_modal_add_unit" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
  <!--begin::Modal dialog-->
  <div class="modal-dialog modal-dialog-centered mw-650px">
         <!--begin::Modal content-->
         <div class="modal-content">
<!--begin::Form-->
<form class="form" action="pages/unit-save.php" id="kt_modal_add_unit_form" data-kt-redirect="units" enctype="multipart/form-data">
       <!--begin::Modal header-->
       <div class="modal-header" id="kt_modal_add_unit_header">
              <!--begin::Modal title-->
              <h2 class="fw-bold">Add a unit</h2>
              <!--end::Modal title-->
              <!--begin::Close-->
              <div id="kt_modal_add_unit_close" class="btn btn-icon btn-sm btn-active-icon-primary">
                     <i class="ki-duotone ki-cross fs-1">
                            <span class="path1"></span>
                            <span class="path2"></span>
                     </i>
              </div>
              <!--end::Close-->
       </div>
       <!--end::Modal header-->
       <!--begin::Modal body-->
       <div class="modal-body py-10 px-lg-17">
              <!--begin::Scroll-->
              <div class="mh-375px scroll-y me-n7 pe-7">
                     <!--begin::Input group-->
                     <div class="fv-row mb-7">
                            <!--begin::Label-->
                            <label class="fs-6 fw-semibold mb-2">
                                   <span>Code</span>
                                   <span class="ms-1" data-bs-toggle="tooltip" title="Code must be unique">
                                          <i class="ki-duotone ki-information fs-4">
                                                 <span class="path1"></span>
                                                 <span class="path2"></span>
                                                 <span class="path3"></span>
                                          </i>
                                   </span>
                            </label>
                            <!--end::Label-->
                            <!--begin::Input-->
                            <div class="input-group mb-2">
                                   <input type="text" class="form-control space-none" placeholder="Code" name="Code" value=""/>
                                   <span class="input-group-text code-search"><i class="bi bi-repeat-1 fs-3"></i></span>
                         </div>
                            <!--end::Input-->
                     </div>
                     <!--end::Input group-->
                     <!--begin::Input group-->
                     <div class="fv-row mb-7">
                            <!--begin::Label-->
                            <label class="fs-6 fw-semibold mb-2">
                                   <span class="required">Name</span>
                                   <span class="ms-1" data-bs-toggle="tooltip" title="Unit name must be unique">
                                          <i class="ki-duotone ki-information fs-4">
                                                 <span class="path1"></span>
                                                 <span class="path2"></span>
                                                 <span class="path3"></span>
                                          </i>
                                   </span>
                            </label>
                            <!--end::Label-->
                            <!--begin::Input-->
                            <div class="input-group mb-2">
                                   <input type="text" class="form-control" placeholder="Unit Name" name="Name" value="" required="required" />
                                   <span class="input-group-text name-search"><i class="bi bi-pencil-square fs-2"></i></span>
                         </div>
                            <!--end::Input-->
                     </div>
                     <!--end::Input group-->
                     <!--begin::Input group-->
                     <div class="fv-row mb-7">
                            <!--begin::Label-->
                            <label class="fs-6 fw-semibold mb-2">Base Unit</label>
                            <!--end::Label-->
                            <!--begin::Select-->
                            <select name="BaseUnit" class="form-select mb-2" data-control="select2" data-dropdown-parent="#kt_modal_add_unit" data-hide-search="true" data-placeholder="Select an option" data-allow-clear="true">
                            <option></option>
                            <?php
                             $UnitQuery=mysqli_query($con,"select * from  mws_unit where UnBaseUnit IS NULL and UnStatus=1 order by UnName ASC");
                             while($UnitField=mysqli_fetch_array($UnitQuery)){
                             ?>
                             <option value="<?php echo $UnitField['UnId'] ?>"><?php echo $UnitField['UnName'] ?></option>
                             <?php } ?>
                            </select>
                            <!--end::Select-->
                     </div>
                     <!--end::Input group-->
                   <div class="base-unit-area">
                     <!--begin::Select Operator-->
                     <div class="fv-row mb-7">
                            <!--begin::Label-->
                            <label class="required fs-6 fw-semibold mb-2">Operator</label>
                            <!--end::Label-->
                            <!--begin::Select-->
                            <select name="Operator" id="Operator" class="form-select mb-2" data-control="select2" data-dropdown-parent="#kt_modal_add_unit" data-hide-search="true" data-placeholder="Select an option" data-allow-clear="true" required="required">
                            <option></option>
                            <?php
                             //$arrayOperator = array('1' =>'Multiply (*)' , '2' =>'Divide (/)' , '3' =>'Plus (+)' , '4' =>'Minus (-)');
                            $arrayOperator = array('1' =>'Multiply (*)' , '2' =>'Divide (/)');
                             foreach ($arrayOperator as $key => $value) {
                             ?>
                             <option value="<?php echo $key ?>"><?php echo $value ?></option>
                             <?php } ?>
                            </select>
                            <!--end::Select-->
                     </div>
                     <!--end::Select Operator-->
                     <!--begin::Input group-->
                     <div class="fv-row mb-7">
                            <!--begin::Label-->
                            <label class="required fs-6 fw-semibold mb-2">Operation Value</label>
                            <!--end::Label-->
                            <!--begin::Input-->
                            <input type="number" min="0" step="any" id="OperationValue" class="form-control" placeholder="Operation Value" name="OperationValue" required="required" />
                            <!--end::Input-->
                     </div>
                     <!--end::Input group-->
                 </div>
              </div>
              <!--end::Scroll-->
       </div>
       <!--end::Modal body-->
       <!--begin::Modal footer-->
       <div class="modal-footer flex-center">
              <!--begin::Button-->
              <button type="reset" id="kt_modal_add_unit_cancel" class="btn btn-light me-3">Discard</button>
              <!--end::Button-->
              <!--begin::Button-->
              <button type="submit" id="kt_modal_add_unit_submit" class="btn btn-primary">
                     <span class="indicator-label">Submit</span>
                     <span class="indicator-progress">Please wait... 
                     <span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
              </button>
              <!--end::Button-->
       </div>
       <!--end::Modal footer-->
</form>
<!--end::Form-->
</div>
  </div>
  <!--end::Modal dialog-->
</div>
<!--begin::Global Javascript Bundle(mandatory for all pages)-->
<!-- <script src="assets/plugins/global/plugins.bundle.js"></script> -->
<!-- <script src="assets/js/scripts.bundle-modal.js"></script> -->
<!--end::Global Javascript Bundle-->
<script type="text/javascript">
(function($){ 

$("input, textarea").on("paste", function() {
  $(this).val($.trim($(this).val()));
});
$("input, textarea").on("keypress", function(e) {
  var startPos = e.currentTarget.selectionStart;
  if (e.which === 32 && startPos==0)
    e.preventDefault();
});
$("input, textarea").on("blur", function(e) {
   $(this).val($.trim($(this).val()));
});

$(".space-none").keypress(function( e ) {
  if(e.which === 32) 
  return false;
});

/*$(document).on('select2:open', function(e) {
 $('.select2-search').css('z-index', 1000).text('Raju').focus();
});*/

/*begin::Code unique*/
let var1=0;
$("input[name=Code]").blur(function() {
  var1=1;
       if($(this).val()){
         $(".code-search").html('<i class="bi bi-arrow-clockwise fs-2 fa-spin"></i>');
         $.get('pages/unit-verify.php?q=' + $(this).val()+'&r=2', function(data) {
           if(data.trim()==0){
             var1=0;
             $(".code-search").html('<i class="bi bi-patch-check-fill fs-2 text-success" data-bs-toggle="tooltip" data-bs-title="This unit code is availabe."></i>');
           } else {
             $(".code-search").html('<i class="bi bi-x-octagon-fill fs-2 text-danger" data-bs-toggle="tooltip" data-bs-title="This unit code is already exist."></i>');
           }
           $('[data-bs-toggle="tooltip"]').tooltip();
         });
       }
       else {
          var1=0;
          $(".code-search").html('<i class="bi bi-repeat-1 fs-3"></i>');
       }
});
/*end::Code unique*/

/*begin::Name unique*/
let var2;
$("input[name=Name]").blur(function() {
  var2=1;
       if($(this).val()){
         $(".name-search").html('<i class="bi bi-arrow-clockwise fs-2 fa-spin"></i>');
         $('.tooltip').empty();
         $.get('pages/unit-verify.php?q=' + $(this).val()+'&r=1', function(data) {
           if(data.trim()==0){
             var2=0;
             $(".name-search").html('<i class="bi bi-patch-check-fill fs-2 text-success" data-bs-toggle="tooltip" data-bs-title="This unit name is availabe."></i>');
           } else {
             $(".name-search").html('<i class="bi bi-x-octagon-fill fs-2 text-danger" data-bs-toggle="tooltip" data-bs-title="This unit name is already exist."></i>');
           }
           $('[data-bs-toggle="tooltip"]').tooltip();
         });
       }
       else {
          $(".name-search").html('<i class="bi bi-pencil-square fs-2"></i>');
       }
});
/*end::Name unique*/

/*begin::Load Base Unit*/
$(".base-unit-area input, .base-unit-area select").prop('disabled', true);
$("select[name=BaseUnit]").change(function() {
     if($(this).val()>=1) {
        $(".base-unit-area").show('slow');
        $(".base-unit-area input, .base-unit-area select").prop('disabled', false);
       } else {
        $(".base-unit-area").hide('slow');
        $(".base-unit-area input, .base-unit-area select").prop('disabled', true);
        $(".base-unit-area input, .base-unit-area select").val(null).trigger('change');
       }
});
/*end::Load Base Unit*/


"use strict";

// Class definition
var KTModalUnitAdd = function () {
    var submitButton;
    var cancelButton;
       var closeButton;
    var validator;
    var form;
    var modal;

    // Init form inputs
    var handleForm = function () {
        // Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/
              
              validator = FormValidation.formValidation(
                     form,
                     {
                            fields: {

                                   'Name': {
                                          validators: {
                                                 notEmpty: {
                                                        message: 'Unit name is required'
                                                 }
                                          }
                                   },
                                   'Operator': {

                                      validators: {
                                          callback: {
                                                 message: 'Operator is required',
                                                 callback: function (input) {
                                                     const c = document.getElementById('OperationValue');
                                                     if (c.disabled == true) {
                                                         return true; // Skip validation
                                                     } 
                                                     return input.value.trim() !== '';
                                                 }
                                             }

                                      }
                                   },
                                   'OperationValue': {

                                      validators: {
                                          callback: {
                                                 message: 'Operation is required',
                                                 callback: function (input) {
                                                     const b = document.getElementById('OperationValue');
                                                     if (b.disabled == true) {
                                                         return true; // Skip validation
                                                     } 
                                                     return input.value.trim() !== '';
                                                 }
                                             }

                                      }
                                   }
                            },
                            plugins: {
                                   trigger: new FormValidation.plugins.Trigger(),
                                   bootstrap: new FormValidation.plugins.Bootstrap5({
                                          rowSelector: '.fv-row',
                        eleInvalidClass: '',
                        eleValidClass: '',
                                   })
                            }
                     }
              );

              $(form.querySelector('[name="Operator"]')).on('change', function () {
                  // Revalidate the field when an option is chosen
                  validator.revalidateField('Operator');
              });

              // Action buttons
              submitButton.addEventListener('click', function (e) {
                     e.preventDefault();

                     if(var1==1){
                    Swal.fire({
                                   text: "Sorry, This unit code already exist.",
                                   icon: "error",
                                   draggable: true,
                                   buttonsStyling: !1,
                                   confirmButtonText: "Ok, got it!",
                                   customClass: {
                                          confirmButton: "btn btn-primary"
                                   }
                          }).then(function(t) {
                                   //alert("Raju");
                                    setTimeout(function () {
                                    let SuppFoc = $("input[name=Code]");
                                    KTUtil.scrollTop(SuppFoc.offset().top);
                                    let SuppLen = SuppFoc.val().length;
                                    SuppFoc[0].focus();
                                    SuppFoc[0].setSelectionRange(len, len);
                               }, 500);
                            });
                        return false;
                   }

                   if(var2==1){
                    Swal.fire({
                                   text: "Sorry, This unit name already exist.",
                                   icon: "error",
                                   draggable: true,
                                   buttonsStyling: !1,
                                   confirmButtonText: "Ok, got it!",
                                   customClass: {
                                          confirmButton: "btn btn-primary"
                                   }
                          }).then(function(t) {
                                   //alert("Raju");
                                    setTimeout(function () {
                                    let SuppFoc = $("input[name=Name]");
                                    KTUtil.scrollTop(SuppFoc.offset().top);
                                    let SuppLen = SuppFoc.val().length;
                                    SuppFoc[0].focus();
                                    SuppFoc[0].setSelectionRange(len, len);
                               }, 500);
                            });
                        return false;
                   }

                     // Validate form before submit
                     if (validator) {
                            validator.validate().then(function (status) {
                                   //console.log('validated!');

                                   if (status == 'Valid') {
                                          submitButton.setAttribute('data-kt-indicator', 'on');

                                          // Disable submit button whilst loading
                                          submitButton.disabled = true;

                                          //setTimeout(function() {
                                          axios.post(submitButton.closest('form').getAttribute('action'), new FormData(form)).then(function (response) {

                                                 submitButton.removeAttribute('data-kt-indicator');
                                                 // Enable submit button after loading
                                                 submitButton.disabled = false;

                                                 //alert(response.data.state);
                                                 if (response.data.state === "success") {

                                                 form.reset(); // Reset form 

                                                 $('select[name=BaseUnit], select[name=Operator]').val(null).trigger('change');

                                                 $(".code-search").html('<i class="bi bi-repeat-1 fs-3"></i>');
                                                 $(".name-search").html('<i class="bi bi-pencil-square fs-2"></i>');
                                                 
                                                 Swal.fire({
                                                        text: "Form has been successfully submitted!",
                                                        icon: "success",
                                                        buttonsStyling: false,
                                                        timer: 3000,
                                                        confirmButtonText: "Ok, got it!",
                                                        customClass: {
                                                               confirmButton: "btn btn-primary"
                                                        }
                                                 }).then(function (result) {
                                                        if (result.isConfirmed) {

                                                               // Hide modal
                                                               modal.hide();

                                    //submitButton.removeAttribute('data-kt-indicator');
                                                               
                                                               // Redirect to units list page
                                                               window.location = form.getAttribute("data-kt-redirect");
                                                        }
                                                 });    
                                            } else {
                            // Show error popup. For more info check the plugin's official documentation: https://sweetalert2.github.io/
                            Swal.fire({
                                text: "Sorry, the code or name is exist, please try again.",
                                icon: "error",
                                buttonsStyling: false,
                                timer: 3000,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-primary"
                                }
                            });
                          }
                                          }).catch(function (error) {
                        Swal.fire({
                            text: "Sorry, looks like there are some errors detected, please try again.",
                            icon: "error",
                            buttonsStyling: false,
                            confirmButtonText: "Ok, got it!",
                            customClass: {
                                confirmButton: "btn btn-primary"
                            }
                        });
                    }).then(() => {
                        // Hide loading indication
                        submitButton.removeAttribute('data-kt-indicator');

                        // Enable button
                        submitButton.disabled = false;
                    });                                        
                                          //}, 2000);                                             
                                   } else {
                                          Swal.fire({
                                                 text: "Sorry, looks like there are some errors detected, please try again.",
                                                 icon: "error",
                                                 buttonsStyling: false,
                                                 confirmButtonText: "Ok, got it!",
                                                 customClass: {
                                                        confirmButton: "btn btn-primary"
                                                 }
                                          });
                                   }
                            });
                     }
              });

        cancelButton.addEventListener('click', function (e) {
            e.preventDefault();

            Swal.fire({
                text: "Are you sure you would like to cancel?",
                icon: "warning",
                showCancelButton: true,
                buttonsStyling: false,
                confirmButtonText: "Yes, cancel it!",
                cancelButtonText: "No, return",
                customClass: {
                    confirmButton: "btn btn-primary",
                    cancelButton: "btn btn-active-light"
                }
            }).then(function (result) {
              
                if (result.value) {
                     //$("#kt_modal_add_unit").modal("hide");
                    form.reset(); // Reset form  
                    modal.hide(); // Hide modal                       
                } else if (result.dismiss === 'cancel') {
                    Swal.fire({
                        text: "Your form has not been cancelled!.",
                        icon: "error",
                        buttonsStyling: false,
                        timer: 2000,
                        confirmButtonText: "Ok, got it!",
                        customClass: {
                            confirmButton: "btn btn-primary",
                        }
                    });
                }
            });
        });

              closeButton.addEventListener('click', function(e){
                     e.preventDefault();

            Swal.fire({
                text: "Are you sure you would like to cancel?",
                icon: "warning",
                showCancelButton: true,
                buttonsStyling: false,
                confirmButtonText: "Yes, cancel it!",
                cancelButtonText: "No, return",
                customClass: {
                    confirmButton: "btn btn-primary",
                    cancelButton: "btn btn-active-light"
                }
            }).then(function (result) {
                if (result.value) {
                    form.reset(); // Reset form  
                    modal.hide(); // Hide modal                       
                } else if (result.dismiss === 'cancel') {
                    Swal.fire({
                        text: "Your form has not been cancelled!.",
                        icon: "error",
                        buttonsStyling: false,
                        timer: 2000,
                        confirmButtonText: "Ok, got it!",
                        customClass: {
                            confirmButton: "btn btn-primary",
                        }
                    });
                }
            });
              })
    }

    return {
        // Public functions
        init: function () {
            // Elements
            modal = new bootstrap.Modal(document.querySelector('#kt_modal_add_unit'));

            form = document.querySelector('#kt_modal_add_unit_form');
            submitButton = form.querySelector('#kt_modal_add_unit_submit');
            cancelButton = form.querySelector('#kt_modal_add_unit_cancel');
                     closeButton = form.querySelector('#kt_modal_add_unit_close');

            handleForm();
            
        }
    };
}();

// On document ready
KTUtil.onDOMContentLoaded(function () {
       KTModalUnitAdd.init();
});    
})(jQuery);
</script>