<link href="assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css"/>
 <!-- Modal HTML -->
<div class="modal fade" id="imageModal" tabindex="-1" aria-labelledby="imageModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered  mw-450px">
    <div class="modal-content">
      <div class="modal-body p-0">
        <img src="" alt="Preview" id="PreImg" class="img-fluid w-100">
      </div>
    </div>
  </div>
</div>
 <!-- Modal HTML -->
<!--begin::Content-->
<div id="kt_app_content" class="app-content flex-column-fluid">
	<!--begin::Content container-->
	<div id="kt_app_content_container" class="app-container container-xxl">
		<!--begin::Card-->
		<div class="card">
			<!--begin::Heading-->
			<div class="text-center mt-4">
				<!--begin::Title-->
				<h1 class="mt-2">Category List</h1>
				<!--end::Title-->
			</div>
			<!--end::Heading-->
			<!--begin::Card header-->
			<div class="card-header border-0 pt-2">
				<!--begin::Card title-->
				<div class="card-title">
					<!--begin::Search-->
					<div class="d-flex align-items-center position-relative my-1">
						<i class="ki-duotone ki-magnifier fs-3 position-absolute ms-5">
							<span class="path1"></span>
							<span class="path2"></span>
						</i>
						<input type="text" data-kt-filter="search" class="form-control form-control-solid w-250px ps-14" placeholder="Search Report" />
					</div>
					<!--end::Search-->
					<!--begin::Export buttons-->
					<div id="kt_datatable_category_1_export" class="d-none"></div>
					<!--end::Export buttons-->
				</div>
				<!--begin::Card title-->
				<!--begin::Card toolbar-->
				<div class="card-toolbar">
					<!--begin::Export dropdown-->
					<button type="button" class="btn btn-light-primary" data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">
						<i class="ki-duotone ki-exit-down fs-2"><span class="path1"></span><span class="path2"></span></i>
						Export Report
					</button>
					<!--begin::Menu-->
					<div id="kt_datatable_category_export_menu" class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-600 menu-state-bg-light-primary fw-semibold fs-7 w-200px py-4" data-kt-menu="true">
						<!--begin::Menu item-->
						<div class="menu-item px-3">
							<a href="#" class="menu-link px-3" data-kt-export="copy">
							Copy to clipboard
							</a>
						</div>
						<!--end::Menu item-->
						<!--begin::Menu item-->
						<div class="menu-item px-3">
							<a href="#" class="menu-link px-3" data-kt-export="excel">
							Export as Excel
							</a>
						</div>
						<!--end::Menu item-->
						<!--begin::Menu item-->
						<div class="menu-item px-3">
							<a href="#" class="menu-link px-3" data-kt-export="csv">
							Export as CSV
							</a>
						</div>
						<!--end::Menu item-->
						<!--begin::Menu item-->
						<div class="menu-item px-3">
							<a href="#" class="menu-link px-3" data-kt-export="pdf">
							Export as PDF
							</a>
						</div>
						<!--end::Menu item-->
					</div>
					<!--end::Menu-->
					<!--end::Export dropdown-->

					<!--begin::Hide default export buttons-->
					<div id="kt_datatable_category_buttons" class="d-none"></div>
					<!--end::Hide default export buttons-->

					<!--begin::Add category-->
					<button type="button" class="btn btn-primary ms-3" data-bs-toggle="modal" data-bs-target="#kt_modal_add_category"><i class="bi bi-cloud-plus fs-3"></i> Add Category</button>
					<!--end::Add category-->
				</div>
				<!--end::Card toolbar-->
			</div>
			<!--end::Card header-->
			<!--begin::Card body-->
			<div class="card-body pt-0">
				<!--begin::Table-->
				<table class="table table-striped table-row-bordered align-middle gy-5 gs-7 border rounded" id="kt_datatable_category">
					<thead>
						<!--begin::Table row-->
						<tr class="text-start text-gray-500 fw-bold fs-7 text-uppercase">
							<th class="text-center">#</th>
							<th class="text-start min-w-100px">Code</th>
							<th class="min-w-150px">Name</th>
							<th class="min-w-150px">Description</th>
							<th class="min-w-100px">Parent</th>
							<th class="text-end min-w-70px">Actions</th>
						</tr>
						<!--end::Table row-->
					</thead>
					<tbody class="fw-semibold text-gray-600">
					<?php
				    $s=0;   
				    $result01=mysqli_query($con, "select * from mws_category where CaStatus=1 order by CaName ASC");
				    while($field01=mysqli_fetch_array($result01))
				    { $s++;

				      $SubCatQuery=mysqli_query($con,"select * from mws_category where CaId='$field01[CaIdParent]'");
                      $SubCatField=mysqli_fetch_array($SubCatQuery);
				    ?>
						<tr class="text-center">
							<td><?php echo $s ?></td>
							<td class="text-start pe-0"><?php echo $field01['CaCode'];?></td>
							<td class="text-start py-2 pe-0">
								<div class="d-flex align-items-center">
									<!--begin::Thumbnail-->
									<?php if(!is_null($field01['CaImage'])){ ?>
									<div data-url="../media/category/<?php echo $field01['CaImage'] ?>" class="symbol symbol-40px me-3 view-modal">
										<span class="symbol-label" style="background-image:url(../media/category/<?php echo $field01['CaImage'] ?>);"></span>
									</div>
								    <?php } ?>
									<!--end::Thumbnail-->
									<div data-kt-category-filter="category_name">
										<?php echo $field01['CaName'] ?>
									</div>
								</div>
							</td>
							<!-- <td class="text-start pe-0" data-kt-category-filter="category_name"><?php echo $field01['CaName'] ?></td> -->
							<td class="text-start pe-0"><?php echo $field01['CaDescription'] ?></td>
							<td class="text-start pe-0"><?php echo $SubCatField['CaName'] ?></td>
							<td class="text-end py-2">
								<a href="#" class="btn btn-sm btn-light btn-flex btn-center btn-active-light-primary" data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">Actions 
								<i class="ki-duotone ki-down fs-5 ms-1"></i></a>
								<!--begin::Menu-->
								<div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-600 menu-state-bg-light-primary fw-semibold fs-7 w-125px py-2" data-kt-menu="true">
									<!--begin::Menu item-->
									<div class="menu-item px-2">
										<a href="#" class="menu-link px-3 py-1"><i class="bi bi-pencil-square"></i>&nbsp;Edit</a>
									</div>
									<!--end::Menu item-->
									<!--begin::Menu item-->
									<div class="menu-item px-2">
										<a href="#" class="menu-link px-3 py-1" data-ca-id="<?php echo $field01['CaId'] ?>" data-kt-category-filter="delete_row"><i class="bi bi-trash3"></i>&nbsp;Delete</a>
									</div>
									<!--end::Menu item-->
								</div>
								<!--end::Menu-->
							</td>
						</tr>
					<?php } ?>
					</tbody>
				</table>
				<!--end::Table-->
			</div>
			<!--end::Card body-->
		</div>
		<!--end::Card-->
	</div>
	<!--end::Content container-->
</div>
<!--end::Content-->

<!--begin::Modal - Category - Add-->
<div class="modal fade" id="kt_modal_add_category" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
	<!--begin::Modal dialog-->
	<div class="modal-dialog modal-dialog-centered mw-650px">
		<!--begin::Modal content-->
		<div class="modal-content">
			<!--begin::Form-->
			<form class="form" action="pages/category-save.php" id="kt_modal_add_category_form" data-kt-redirect="<?php echo $loc ?>/categories" enctype="multipart/form-data">
				<!--begin::Modal header-->
				<div class="modal-header" id="kt_modal_add_category_header">
					<!--begin::Modal title-->
					<h2 class="fw-bold">Add a category</h2>
					<!--end::Modal title-->
					<!--begin::Close-->
					<div id="kt_modal_add_category_close" class="btn btn-icon btn-sm btn-active-icon-primary">
						<i class="ki-duotone ki-cross fs-1">
							<span class="path1"></span>
							<span class="path2"></span>
						</i>
					</div>
					<!--end::Close-->
				</div>
				<!--end::Modal header-->
				<!--begin::Modal body-->
				<div class="modal-body py-10 px-lg-17">
					<!--begin::Scroll-->
					<div class="scroll-y me-n7 pe-7" id="kt_modal_add_category_scroll" data-kt-scroll="true" data-kt-scroll-activate="{default: false, lg: true}" data-kt-scroll-max-height="auto" data-kt-scroll-dependencies="#kt_modal_add_category_header" data-kt-scroll-wrappers="#kt_modal_add_category_scroll" data-kt-scroll-offset="300px">
						<!--begin::Input group-->
						<div class="fv-row mb-7">
							<!--begin::Label-->
							<label class="fs-6 fw-semibold mb-2">
								<span class="required">Code</span>
								<span class="ms-1" data-bs-toggle="tooltip" title="Code must be unique">
									<i class="ki-duotone ki-information fs-4">
										<span class="path1"></span>
										<span class="path2"></span>
										<span class="path3"></span>
									</i>
								</span>
							</label>
							<!--end::Label-->
							<!--begin::Input-->
							<div class="input-group mb-2">
								<input type="text" class="form-control" placeholder="Code" name="Code" value="" required="required" />
								<span class="input-group-text code-search"><i class="bi bi-repeat-1 fs-3"></i></span>
						    </div>
							<!--end::Input-->
						</div>
						<!--end::Input group-->
						<!--begin::Input group-->
						<div class="fv-row mb-7">
							<!--begin::Label-->
							<label class="fs-6 fw-semibold mb-2">
								<span class="required">Name</span>
								<span class="ms-1" data-bs-toggle="tooltip" title="Category name must be unique">
									<i class="ki-duotone ki-information fs-4">
										<span class="path1"></span>
										<span class="path2"></span>
										<span class="path3"></span>
									</i>
								</span>
							</label>
							<!--end::Label-->
							<!--begin::Input-->
							<div class="input-group mb-2">
								<input type="text" class="form-control" placeholder="Category Name" name="Name" value="" required="required" />
								<span class="input-group-text name-search"><i class="bi bi-pencil-square fs-2"></i></span>
						    </div>
							<!--end::Input-->
						</div>
						<!--end::Input group-->
						<!--begin::Input group-->
						<div class="fv-row mb-7">
							<!--begin::Label-->
							<label class="fs-6 fw-semibold mb-2">Description</label>
							<!--end::Label-->
							<!--begin::Input-->
							<input type="text" class="form-control" placeholder="Description" name="Description" />
							<!--end::Input-->
						</div>
						<!--end::Input group-->
						<!--begin::Select Category-->
						<div class="fv-row mb-7">
							<!--begin::Label-->
							<label class="fs-6 fw-semibold mb-2">Parent Category</label>
							<!--end::Label-->
							<!--begin::Select-->
							<select name="Category" class="form-select mb-2" data-control="select2" data-hide-search="false" data-placeholder="Select an option">
								<option></option>
								<?php
						        $CategoryQuery=mysqli_query($con,"select * from  mws_category where CaIdParent IS NULL and CaStatus=1 order by CaName ASC");
						        while($CategoryField=mysqli_fetch_array($CategoryQuery)){
						        ?>
						        <option value="<?php echo $CategoryField['CaId'] ?>"><?php echo $CategoryField['CaName'] ?></option>
						        <?php } ?>
							</select>
							<!--end::Select-->
						</div>
						<!--end::Select Category-->
						<!--begin::Thumbnail settings-->
						<div class="card card-flush py-4 mb-5">
							<!--begin::Card header-->
							<div class="card-header">
								<!--begin::Card title-->
								<div class="card-title">
									<h4>Image</h4>
								</div>
								<!--end::Card title-->
							</div>
							<!--end::Card header-->
							<!--begin::Card body-->
							<div class="card-body text-center pt-0">
								<!--begin::Image input-->
								<!--begin::Image input placeholder-->
								<style>.image-input-placeholder { background-image: url('assets/media/svg/files/blank-image.svg'); } [data-bs-theme="dark"] .image-input-placeholder { background-image: url('assets/media/svg/files/blank-image-dark.svg'); }</style>
								<!--end::Image input placeholder-->
								<div id="xyz" class="image-input image-input-empty image-input-outline image-input-placeholder mb-3" data-kt-image-input="true">
									<!--begin::Preview existing avatar-->
									<div class="image-input-wrapper w-200px h-200px"></div>
									<!--end::Preview existing avatar-->
									<!--begin::Label-->
									<label class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="change" data-bs-toggle="tooltip" data-bs-title="Add product image">
										<i class="ki-duotone ki-pencil fs-7">
											<span class="path1"></span>
											<span class="path2"></span>
										</i>
										<!--begin::Inputs-->
										<input type="file" name="CategoryImage" accept=".png, .jpg, .jpeg" id="CategoryImage"/>
										<input type="hidden" name="CategoryImage_remove" />
										<!--end::Inputs-->
									</label>
									<!--end::Label-->
									<!--begin::Cancel-->
									<span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="cancel" data-bs-toggle="tooltip" data-bs-title="Cancel product image">
										<i class="ki-duotone ki-cross fs-2">
											<span class="path1"></span>
											<span class="path2"></span>
										</i>
									</span>
									<!--end::Cancel-->
									<!--begin::Remove-->
									<span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="remove" data-bs-toggle="tooltip" data-bs-title="Remove product image">
										<i class="ki-duotone ki-cross fs-2">
											<span class="path1"></span>
											<span class="path2"></span>
										</i>
									</span>
									<!--end::Remove-->
								</div>
								<!--end::Image input-->
								<!--begin::Description-->
								<div class="text-muted fs-7">Set the product thumbnail image. Only *.png, *.jpg and *.jpeg image files are accepted. Max. file size 1MB. Standard Dim: 600px&#215;600px</div>
								<!--end::Description-->
							</div>
							<!--end::Card body-->
						</div>
						<!--end::Thumbnail settings-->
					</div>
					<!--end::Scroll-->
				</div>
				<!--end::Modal body-->
				<!--begin::Modal footer-->
				<div class="modal-footer flex-center">
					<!--begin::Button-->
					<button type="reset" id="kt_modal_add_category_cancel" class="btn btn-light me-3">Discard</button>
					<!--end::Button-->
					<!--begin::Button-->
					<button type="submit" id="kt_modal_add_category_submit" class="btn btn-primary">
						<span class="indicator-label">Submit</span>
						<span class="indicator-progress">Please wait... 
						<span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
					</button>
					<!--end::Button-->
				</div>
				<!--end::Modal footer-->
			</form>
			<!--end::Form-->
		</div>
	</div>
</div>
<!--end::Modal - Category - Add-->

<script src="assets/plugins/custom/datatables/datatables.bundle.js"></script>
<script>
$("input, textarea").on("paste", function() {
  $(this).val($.trim($(this).val()));
});
$("input, textarea").on("keypress", function(e) {
  var startPos = e.currentTarget.selectionStart;
  if (e.which === 32 && startPos==0)
    e.preventDefault();
});
$("input, textarea").on("blur", function(e) {
   $(this).val($.trim($(this).val()));
});

/*begin::Code unique*/
let var1;
$("input[name=Code]").blur(function() {
  var1=1;
	if($(this).val()){
	  $(".code-search").html('<i class="bi bi-arrow-clockwise fs-2 fa-spin"></i>');
	  $.get('<?php echo $loc ?>/pages/category-verify.php?q=' + $(this).val()+'&r=2', function(data) {
	    if(data.trim()==0){
	      var1=0;
	      $(".code-search").html('<i class="bi bi-patch-check-fill fs-2 text-success" data-bs-toggle="tooltip" data-bs-title="This category code is availabe."></i>');
	    } else {
	      $(".code-search").html('<i class="bi bi-x-octagon-fill fs-2 text-danger" data-bs-toggle="tooltip" data-bs-title="This category code is already exist."></i>');
	    }
	    $('[data-bs-toggle="tooltip"]').tooltip();
	  });
	}
	else {
	   $(".code-search").html('<i class="bi bi-repeat-1 fs-3"></i>');
	}
});
/*end::Code unique*/

/*begin::Name unique*/
let var2;
$("input[name=Name]").blur(function() {
  var2=1;
	if($(this).val()){
	  $(".name-search").html('<i class="bi bi-arrow-clockwise fs-2 fa-spin"></i>');
	  $.get('<?php echo $loc ?>/pages/category-verify.php?q=' + $(this).val()+'&r=1', function(data) {
	    if(data.trim()==0){
	      var2=0;
	      $(".name-search").html('<i class="bi bi-patch-check-fill fs-2 text-success" data-bs-toggle="tooltip" data-bs-title="This category name is availabe."></i>');
	    } else {
	      $(".name-search").html('<i class="bi bi-x-octagon-fill fs-2 text-danger" data-bs-toggle="tooltip" data-bs-title="This category name is already exist."></i>');
	    }
	    $('[data-bs-toggle="tooltip"]').tooltip();
	  });
	}
	else {
	   $(".name-search").html('<i class="bi bi-pencil-square fs-2"></i>');
	}
});
/*end::Name unique*/


$('.view-modal').on('click', function(e){
  e.preventDefault();
  //alert($(this).data("url"));
  $('#imageModal').modal('show');
  //$('#PreImg').attr('src',$(this).data("url"));
  $('#imageModal .modal-content .modal-body #PreImg').attr('src',$(this).data("url"));
});

"use strict";

// Class definition
var KTDatatablesCategory = function () {
    // Shared variables
    var table;
    var datatable;
    var submitButton;
    var cancelButton;
	var closeButton;
    var validator;
    var form;
    var modal;

    // Private functions
    var initDatatable = function () {
        // Set date data order
        const tableRows = table.querySelectorAll('tbody tr');

        tableRows.forEach(row => {
            const dateRow = row.querySelectorAll('td');
            const realDate = moment(dateRow[3].innerHTML, "DD MMM YYYY, LT").format(); // select date from 4th column in table
            dateRow[3].setAttribute('data-order', realDate);
        });

        // Init datatable --- more info on datatables: https://datatables.net/manual/
        datatable = $(table).DataTable({
            "info": false,
            'order': [],
            'pageLength': 10,
        });
    }

    // Hook export buttons
    var exportButtons = () => {
        const documentTitle = 'Category List';
        var buttons = new $.fn.dataTable.Buttons(table, {
            buttons: [
                {
                    extend: 'copyHtml5',
                    title: documentTitle
                },
                {
                    extend: 'excelHtml5',
                    title: documentTitle
                },
                {
                    extend: 'csvHtml5',
                    title: documentTitle
                },
                {
                    extend: 'pdfHtml5',
                    title: documentTitle
                }
            ]
        }).container().appendTo($('#kt_datatable_category_buttons'));

        // Hook dropdown menu click event to datatable export buttons
        const exportButtons = document.querySelectorAll('#kt_datatable_category_export_menu [data-kt-export]');
        exportButtons.forEach(exportButton => {
            exportButton.addEventListener('click', e => {
                e.preventDefault();

                // Get clicked export value
                const exportValue = e.target.getAttribute('data-kt-export');
                const target = document.querySelector('.dt-buttons .buttons-' + exportValue);

                // Trigger click event on hidden datatable export buttons
                target.click();
            });
        });
    }

    // Search Datatable --- official docs reference: https://datatables.net/reference/api/search()
    var handleSearchDatatable = () => {
        const filterSearch = document.querySelector('[data-kt-filter="search"]');
        filterSearch.addEventListener('keyup', function (e) {
            datatable.search(e.target.value).draw();
        });
    }


    // Delete cateogry
    var handleDeleteRows = () => {
    	// Select all delete buttons
        const deleteButtons = table.querySelectorAll('[data-kt-category-filter="delete_row"]');
        deleteButtons.forEach(d => {
            // Delete button on click
            d.addEventListener('click', function (e) {
                e.preventDefault();
                // Select parent row
                const parent = e.target.closest('tr');

                // Get category name
                const categoryName = parent.querySelector('[data-kt-category-filter="category_name"]').innerText;

                const caid = this.getAttribute('data-ca-id');

                // SweetAlert2 pop up --- official docs reference: https://sweetalert2.github.io/
                Swal.fire({
                    text: "Are you sure you want to delete " + categoryName + "?",
                    icon: "warning",
                    showCancelButton: true,
                    buttonsStyling: false,
                    confirmButtonText: "Yes, delete!",
                    cancelButtonText: "No, cancel",
                    customClass: {
                        confirmButton: "btn fw-bold btn-danger",
                        cancelButton: "btn fw-bold btn-active-light-primary"
                    }
                }).then(function (result) {
                    if (result.value) {

                        axios.get('pages/category-delete.php', {
						  params: {
						    id: caid,
						    status: 1
						  }
						})
						.then(response => {
						  //console.log(response.data);
						  //alert(response.data.state);
						  Swal.fire({
	                            text: "You have deleted " + categoryName + "!.",
	                            icon: "success",
	                            buttonsStyling: false,
	                            confirmButtonText: "Ok, got it!",
	                            customClass: {
	                                confirmButton: "btn fw-bold btn-primary",
	                            }
	                        }).then(function () {
	                            // Remove current row
	                            datatable.row($(parent)).remove().draw();
	                        });

						})
						.catch(error => {
						  //console.error(error);
						});

                    } else if (result.dismiss === 'cancel') {
                        Swal.fire({
                            text: categoryName + " was not deleted.",
                            icon: "error",
                            buttonsStyling: false,
                            confirmButtonText: "Ok, got it!",
                            customClass: {
                                confirmButton: "btn fw-bold btn-primary",
                            }
                        });
                    }
                });
            })
        });
    }
    
    // Init form inputs
    var handleForm = function () {
        // Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/
		validator = FormValidation.formValidation(
			form,
			{
				fields: {
                    'Code': {
						validators: {
							notEmpty: {
								message: 'Code is required'
							}
						}
					},
					'Name': {
						validators: {
							notEmpty: {
								message: 'Barnd name is required'
							}
						}
					}
				},
				plugins: {
					trigger: new FormValidation.plugins.Trigger(),
					bootstrap: new FormValidation.plugins.Bootstrap5({
						rowSelector: '.fv-row',
                        eleInvalidClass: '',
                        eleValidClass: ''
					})
				}
			}
		);

		// Action buttons
		submitButton.addEventListener('click', function (e) {
			e.preventDefault();

			if(var1==1){
		      Swal.fire({
					text: "Sorry, This category code already exist.",
					icon: "error",
					draggable: true,
					buttonsStyling: !1,
					confirmButtonText: "Ok, got it!",
					customClass: {
						confirmButton: "btn btn-primary"
					}
			     }).then(function(t) {
					//alert("Raju");
					 setTimeout(function () {
					 let SuppFoc = $("input[name=Code]");
					 KTUtil.scrollTop(SuppFoc.offset().top);
					 let SuppLen = SuppFoc.val().length;
					 SuppFoc[0].focus();
					 SuppFoc[0].setSelectionRange(len, len);
				   }, 500);
				});
			   return false;
		     }

		     if(var2==1){
		      Swal.fire({
					text: "Sorry, This category name already exist.",
					icon: "error",
					draggable: true,
					buttonsStyling: !1,
					confirmButtonText: "Ok, got it!",
					customClass: {
						confirmButton: "btn btn-primary"
					}
			     }).then(function(t) {
					//alert("Raju");
					 setTimeout(function () {
					 let SuppFoc = $("input[name=Name]");
					 KTUtil.scrollTop(SuppFoc.offset().top);
					 let SuppLen = SuppFoc.val().length;
					 SuppFoc[0].focus();
					 SuppFoc[0].setSelectionRange(len, len);
				   }, 500);
				});
			   return false;
		     }

		     if($('#CategoryImage').val()!=''){
			    var file_size = $('#CategoryImage')[0].files[0].size;
			    /*1KB=1024*/
			    if(file_size>1048576) {
			    //alert("Picture size is greater than 1MB");
			    Swal.fire({
					text: "Sorry, Category Image size is greater than 1MB.",
					icon: "error",
					draggable: true,
					buttonsStyling: !1,
					confirmButtonText: "Ok, got it!",
					customClass: {
						confirmButton: "btn btn-primary"
					}
			     }).then(function(t) {
					 setTimeout(function () {
					 var scrollTopElement = document.querySelector("#xyz");
		             var scrollTop = KTScrolltop.getInstance(scrollTopElement);
				   }, 500);
				});
			    return false;
			    }
			  }

			// Validate form before submit
			if (validator) {
				validator.validate().then(function (status) {
					//console.log('validated!');

					if (status == 'Valid') {
						submitButton.setAttribute('data-kt-indicator', 'on');

						// Disable submit button whilst loading
						submitButton.disabled = true;

						//setTimeout(function() {
						axios.post(submitButton.closest('form').getAttribute('action'), new FormData(form)).then(function (response) {

							submitButton.removeAttribute('data-kt-indicator');
							// Enable submit button after loading
							submitButton.disabled = false;

							//alert(response.data.state);
							if (response.data.state === "success") {

                            $(".image-input-wrapper").css('background-image', 'none');
							form.reset(); // Reset form	

							$(".code-search").html('<i class="bi bi-repeat-1 fs-3"></i>');
							$(".name-search").html('<i class="bi bi-pencil-square fs-2"></i>');
							
							Swal.fire({
								text: "Form has been successfully submitted!",
								icon: "success",
								buttonsStyling: false,
								timer: 3000,
								confirmButtonText: "Ok, got it!",
								customClass: {
									confirmButton: "btn btn-primary"
								}
							}).then(function (result) {
								if (result.isConfirmed) {

									// Hide modal
									modal.hide();

                                    //submitButton.removeAttribute('data-kt-indicator');
									
									// Redirect to categories list page
									window.location = form.getAttribute("data-kt-redirect");
								}
							});	
						  } else {
                            // Show error popup. For more info check the plugin's official documentation: https://sweetalert2.github.io/
                            Swal.fire({
                                text: "Sorry, the code or name is exist, please try again.",
                                icon: "error",
                                buttonsStyling: false,
                                timer: 3000,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-primary"
                                }
                            });
                          }
						}).catch(function (error) {
                        Swal.fire({
                            text: "Sorry, looks like there are some errors detected, please try again.",
                            icon: "error",
                            buttonsStyling: false,
                            confirmButtonText: "Ok, got it!",
                            customClass: {
                                confirmButton: "btn btn-primary"
                            }
                        });
                    }).then(() => {
                        // Hide loading indication
                        submitButton.removeAttribute('data-kt-indicator');

                        // Enable button
                        submitButton.disabled = false;
                    });						
						//}, 2000);   						
					} else {
						Swal.fire({
							text: "Sorry, looks like there are some errors detected, please try again.",
							icon: "error",
							buttonsStyling: false,
							confirmButtonText: "Ok, got it!",
							customClass: {
								confirmButton: "btn btn-primary"
							}
						});
					}
				});
			}
		});

        cancelButton.addEventListener('click', function (e) {
            e.preventDefault();

            Swal.fire({
                text: "Are you sure you would like to cancel?",
                icon: "warning",
                showCancelButton: true,
                buttonsStyling: false,
                confirmButtonText: "Yes, cancel it!",
                cancelButtonText: "No, return",
                customClass: {
                    confirmButton: "btn btn-primary",
                    cancelButton: "btn btn-active-light"
                }
            }).then(function (result) {
                if (result.value) {
                	$(".image-input-wrapper").css('background-image', 'none');
                    form.reset(); // Reset form	
                    modal.hide(); // Hide modal				
                } else if (result.dismiss === 'cancel') {
                    Swal.fire({
                        text: "Your form has not been cancelled!.",
                        icon: "error",
                        buttonsStyling: false,
                        timer: 2000,
                        confirmButtonText: "Ok, got it!",
                        customClass: {
                            confirmButton: "btn btn-primary",
                        }
                    });
                }
            });
        });

		closeButton.addEventListener('click', function(e){
			e.preventDefault();

            Swal.fire({
                text: "Are you sure you would like to cancel?",
                icon: "warning",
                showCancelButton: true,
                buttonsStyling: false,
                confirmButtonText: "Yes, cancel it!",
                cancelButtonText: "No, return",
                customClass: {
                    confirmButton: "btn btn-primary",
                    cancelButton: "btn btn-active-light"
                }
            }).then(function (result) {
                if (result.value) {
                	$(".image-input-wrapper").css('background-image', 'none');
                    form.reset(); // Reset form	
                    modal.hide(); // Hide modal				
                } else if (result.dismiss === 'cancel') {
                    Swal.fire({
                        text: "Your form has not been cancelled!.",
                        icon: "error",
                        buttonsStyling: false,
                        timer: 2000,
                        confirmButtonText: "Ok, got it!",
                        customClass: {
                            confirmButton: "btn btn-primary",
                        }
                    });
                }
            });
		})
    }
    // Public methods
    return {
        init: function () {
            table = document.querySelector('#kt_datatable_category');

            if ( !table ) {
                return;
            }

            initDatatable();
            exportButtons();
            handleSearchDatatable();
            handleDeleteRows();

            modal = new bootstrap.Modal(document.querySelector('#kt_modal_add_category'));

            form = document.querySelector('#kt_modal_add_category_form');
            submitButton = form.querySelector('#kt_modal_add_category_submit');
            cancelButton = form.querySelector('#kt_modal_add_category_cancel');
			closeButton = form.querySelector('#kt_modal_add_category_close');

            handleForm();

        }
    };
}();

// On document ready
KTUtil.onDOMContentLoaded(function () {
    KTDatatablesCategory.init();
});

</script>
