<?php
     include_once 'config-data.php';

    function generateBarcode($type, $digits, $numberSystem = '0') {
    // Keep only digits
    $digits = preg_replace('/\D/', '', $digits);

    switch (strtoupper($type)) {
        case 'UPC_A':
            return $digits . calculateCheckDigit($digits);

        case 'EAN_13':
            return $digits . calculateCheckDigit($digits);

        case 'EAN_8':
            return $digits . calculateCheckDigit($digits);

        case 'UPC_E':
            // Expand to UPC-A for check digit calculation
            $lastDigit = (int)$digits[5];
            switch ($lastDigit) {
                case 0:
                case 1:
                case 2:
                    $upca = $numberSystem . substr($digits, 0, 2) . $lastDigit . "0000" . substr($digits, 2, 3);
                    break;
                case 3:
                    $upca = $numberSystem . substr($digits, 0, 3) . "00000" . substr($digits, 3, 2);
                    break;
                case 4:
                    $upca = $numberSystem . substr($digits, 0, 4) . "00000" . $digits[4];
                    break;
                default:
                    $upca = $numberSystem . substr($digits, 0, 5) . "0000" . $lastDigit;
                    break;
            }

            $checkDigit = calculateCheckDigit($upca);
            return $numberSystem . $digits . $checkDigit;
    }
}

function calculateCheckDigit($codeWithoutCheckDigit) {
    $len = strlen($codeWithoutCheckDigit);
    $sumOdd = 0;
    $sumEven = 0;

    // Right-to-left position numbering
    for ($i = $len - 1, $pos = 1; $i >= 0; $i--, $pos++) {
        if ($pos % 2 === 0) {
            $sumEven += (int)$codeWithoutCheckDigit[$i];
        } else {
            $sumOdd += (int)$codeWithoutCheckDigit[$i];
        }
    }

    // UPC-A / EAN rules: multiply sumOdd by 3, then add sumEven
    $total = ($sumOdd * 3) + $sumEven;
    $modulo = $total % 10;
    return ($modulo === 0) ? 0 : 10 - $modulo;
}

  // Generate unique number
  $Barcode = $_GET['Barcode'];
  $Bcmin = [ 3=>10000000, 4=>1000000, 5=>100000000000, 6=>10000000000, 7=>100000 ];
  $Bcmax = [ 3=>99999999, 4=>9999999, 5=>999999999999, 6=>99999999999, 7=>999999 ];
  if($Barcode<=3){
    $Barcode=3;
  }
  do {
      //random_int() is safer — it supports full 64-bit range on 64-bit PHP. But 32-bit PHP can’t handle random_int()
      $r=random_int($Bcmin[$Barcode], $Bcmax[$Barcode]);
      if($Barcode>=4){
        $BcType=[4=>'EAN_8', 5=>'EAN_13', 6=>'UPC_A', 7=>'UPC_E'];
        $random_id = generateBarcode($BcType[$Barcode], $r);
      } else {
        $random_id = $r;
      }
      $result01=mysqli_query($con,"SELECT * FROM mws_product WHERE RegId='$RegId' and PrCode = '$random_id'");
      $row01=mysqli_num_rows($result01);
  } while($result01 && $row01 > 0);
   
  echo $random_id;
?>