<?php 
$proquery = $conn->query("SELECT * FROM student WHERE StId = '$UserId'");
$field01 = $proquery->fetch_assoc();
?>
<!--begin::Content-->
<div id="kt_app_content" class="app-content flex-column-fluid">
	<!--begin::Content container-->
	<div id="kt_app_content_container" class="app-container container-xxl">
		<!--begin::Contact-->
		<div class="card">
			<div class="card-header">
		        <h1 class="card-title fw-bold text-gray-900"><i class="bi bi-person-fill-lock fs-6"></i>&nbsp;Password Change</h1>
		    </div>
			<!--begin::Body-->
			<div class="card-body">
				<!--begin::Form-->
				<?php $_SESSION['token'] = bin2hex(random_bytes(32)); ?>
				<form action="pages/pass-update.php" method="post" id="kt_pass_form" class="form" enctype="multipart/form-data">
				<input type="hidden" name="token" value="<?php echo $_SESSION['token']; ?>">
				<div class="row justify-content-center">
					<div class="col-md-6 col-sm-8 align-self-center">
						<!--begin::Input Current Password-->
						<div class="mb-5 fv-row">
							<!--begin::Label-->
							<label class="required form-label">Current Password</label>
							<!--end::Label-->
							<!--begin::Input-->
							<input type="password" minlength="6" maxlength="12" name="CurrentPassword" value="" class="form-control mb-2" placeholder="Current Password" required="required" />
							<!--end::Input-->
						</div>
						<!--end::Input Current Password-->
						<!--begin::Input New  Password-->
						<div class="mb-5 fv-row">
							<!--begin::Label-->
							<label class="required form-label">New  Password</label>
							<!--end::Label-->
							<!--begin::Input-->
							<div class="input-group mb-2">
						        <input type="password" minlength="6" maxlength="12" name="NewPassword" value="" id="new_password" class="form-control" placeholder="New  Password" required="required" />
						        <span class="input-group-text toggle-password " style="cursor: pointer; z-index: 10; background: transparent;"><i class="bi bi-eye"></i></span>
						    </div>
							<!--end::Input-->
						</div>
						<!--end::Input New  Password-->
						<!--begin::Input Confirm New  Password-->
						<div class="mb-5 fv-row">
							<!--begin::Label-->
							<label class="required form-label">Confirm New Password</label>
							<!--end::Label-->
							<!--begin::Input-->
							<input type="password" minlength="6" maxlength="12" name="ConfirmPassword" value="" class="form-control mb-2" placeholder="Confirm New Password" required="required" />
							<!--end::Input-->
						</div>
						<!--end::Input Confirm New  Password-->
					</div>
				</div>
				<!--end::Card-->

				<div class="d-flex justify-content-end">
					<!--begin::Submit-->
					<button type="submit" class="btn btn-primary" id="kt_pass_submit">
						<!--begin::Indicator label-->
						<span class="indicator-label">Update Password</span>
						<!--end::Indicator label-->
						<!--begin::Indicator progress-->
						<span class="indicator-progress">Please wait... 
						<span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
						<!--end::Indicator progress-->
					</button>
					<!--end::Submit-->
				</div>

				</form>
				<!--end::Form-->
			</div>
			<!--end::Body-->
		</div>
		<!--end::Contact-->
	</div>
	<!--end::Content container-->
</div>
<!--end::Content-->

<script>
(function($){ 
$("input, textarea").on("paste", function() {
  $(this).val($.trim($(this).val()));
});
$("input, textarea").on("keypress", function(e) {
  var startPos = e.currentTarget.selectionStart;
  if (e.which === 32 && startPos==0)
    e.preventDefault();
});
$("input, textarea").on("blur", function(e) {
   $(this).val($.trim($(this).val()));
});

$('.toggle-password').on('click', function() {
    const input = $(this).siblings('input');
    const icon = $(this).find('i');
    
    if (input.attr('type') === 'password') {
        input.attr('type', 'text');
        icon.removeClass('bi-eye').addClass('bi-eye-slash');
    } else {
        input.attr('type', 'password');
        icon.removeClass('bi-eye-slash').addClass('bi-eye');
    }
});

"use strict";

// Class definition
var KTModalUnitAdd = function () {
    var submitButton;
    var validator;
    var form;

    // Init form inputs
    var handleForm = function () {
              
	  validator = FormValidation.formValidation(
	         form,
	         {
	          fields: {
	            CurrentPassword: {
	                validators: {
	                    notEmpty: { message: 'Current password is required' }
	                }
	            },
	            NewPassword: {
				    validators: {
				        notEmpty: { message: 'New password is required' },
				        stringLength: {
				            min: 6,
				            max: 12,
				            message: 'Password must be between 6 and 8 characters long'
				        },
				        different: {
				            compare: function() {
				                return form.querySelector('[name="CurrentPassword"]').value;
				            },
				            message: 'The new password cannot be the same as the current password'
				        }
				    }
				},
	            ConfirmPassword: {
	                validators: {
	                    notEmpty: { message: 'Please confirm your new password' },
	                    identical: {
	                        compare: function() {
	                            return form.querySelector('[name="NewPassword"]').value;
	                        },
	                        message: 'The new password and its confirm are not the same'
	                    }
	                }
	            }
	        },
	        plugins: {
	            trigger: new FormValidation.plugins.Trigger(),
	            bootstrap: new FormValidation.plugins.Bootstrap5({
	                rowSelector: '.fv-row',
	                eleInvalidClass: '',
                    eleValidClass: '',
	            }),
	            submitButton: new FormValidation.plugins.SubmitButton(),
	            icon: new FormValidation.plugins.Icon({
	                valid: 'fa fa-check',
	                invalid: 'fa fa-times',
	                validating: 'fa fa-refresh',
	            }),
	        }
	       }
	      );

          // Action buttons
		submitButton.addEventListener('click', function(e) {
		   e.preventDefault();

		   // Validate form before submit
		   if (validator) {
		      validator.validate().then(function(status) {
		         //console.log('validated!');

		         if (status == 'Valid') {
		            submitButton.setAttribute('data-kt-indicator', 'on');

		            // Disable submit button whilst loading
		            submitButton.disabled = true;

		            //setTimeout(function() {
		            axios.post(submitButton.closest('form').getAttribute('action'), new FormData(form)).then(function(response) {

		               submitButton.removeAttribute('data-kt-indicator');
		               // Enable submit button after loading
		               submitButton.disabled = false;

		               //alert(response.data.state);
		               if (response.data.state === "success") {

		                  //form.reset(); // Reset form 

		                  Swal.fire({
		                     text: "Password has been successfully updated!",
		                     icon: "success",
		                     buttonsStyling: false,
		                     timer: 3000,
		                     confirmButtonText: "Ok, got it!",
		                     customClass: {
		                        confirmButton: "btn btn-primary"
		                     }
		                  }).then(() => {
		                    form.reset();
		                    fv.resetForm(true);
		                });
		               } else {
		                  // Show error popup. For more info check the plugin's official documentation: https://sweetalert2.github.io/
		                  Swal.fire({
		                     text: response.data.message,
		                     icon: "error",
		                     buttonsStyling: false,
		                     timer: 3000,
		                     confirmButtonText: "Ok, got it!",
		                     customClass: {
		                        confirmButton: "btn btn-primary"
		                     }
		                  });
		               }
		            }).catch(function(error) {
		               Swal.fire({
		                  text: "Sorry, looks like there are some errors detected, please try again.",
		                  icon: "error",
		                  buttonsStyling: false,
		                  confirmButtonText: "Ok, got it!",
		                  customClass: {
		                     confirmButton: "btn btn-primary"
		                  }
		               });
		            }).then(() => {
		               // Hide loading indication
		               submitButton.removeAttribute('data-kt-indicator');

		               // Enable button
		               submitButton.disabled = false;
		            });
		            //}, 2000);                                             
		         } else {
		            Swal.fire({
		               text: "Sorry, looks like there are some errors detected, please try again.",
		               icon: "error",
		               buttonsStyling: false,
		               confirmButtonText: "Ok, got it!",
		               customClass: {
		                  confirmButton: "btn btn-primary"
		               }
		            });
		         }
		      });
		   }
		});
    }

    return {
        // Public functions
        init: function () {
            // Elements
			form = document.querySelector('#kt_pass_form');
			submitButton = form.querySelector('#kt_pass_submit');
			handleForm();
            
        }
    };
}();

// On document ready
KTUtil.onDOMContentLoaded(function () {
       KTModalUnitAdd.init();
});    
})(jQuery);

</script>