<?php
	include_once 'config-data.php';

	// 1. Check if the request is actually a POST request
	if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
	    header("Location: ../"); // Redirect hackers/misclicks
	    exit;
	}

	// 2. Validate the CSRF token from the POST data
	if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
	    //die("Security violation: Invalid CSRF token.");
		header("Location: ../"); // Redirect hackers/misclicks
	   exit;
	}

	// 3. Database Cleanup (Clear 'Remember Me' token)
	if (isset($_COOKIE['remember_me'])) {
	    $parts = explode('|', $_COOKIE['remember_me']);
	    if (count($parts) === 2) {
	        $user_id = $parts[0];
	        
	        if (ctype_digit($user_id)) {
            $stmt = $conn->prepare("UPDATE student SET StRemToken = NULL WHERE StId = ?");
            $stmt->bind_param("i", $user_id);
            $stmt->execute();
            $stmt->close();
        	  }
	    }
	    // Delete the cookie
	    setcookie('remember_me', '', time() - 3600, '/');
	}

	// 4. Destroy Session
	$_SESSION = array();
	if (ini_get("session_use_cookies")) {
	    $params = session_get_cookie_params();
	    setcookie(session_name(), '', time() - 42000,
	        $params["path"], $params["domain"],
	        $params["secure"], $params["httponly"]
	    );
	}
	session_destroy();
	// 5. Regenerate session ID (extra safety)
	session_start();
	session_regenerate_id(true);

	// 6. Success Redirect
	header("Location: ../../");
	exit;
	
?> 
