<?php
include_once 'config-data.php';
?>
<div class="modal fade kt_modal_add" id="kt_modal_add_gc" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
  <!--begin::Modal dialog-->
  <div class="modal-dialog modal-dialog-centered mw-650px">
 <!--begin::Modal content-->
 <div class="modal-content">
<!--begin::Form-->
<form class="form" id="kt_modal_add_gc_form">
       <!--begin::Modal header-->
       <div class="modal-header" id="kt_modal_add_gc_header">
              <!--begin::Modal title-->
              <h2 class="fw-bold">Add a gift card</h2>
              <!--end::Modal title-->
              <!--begin::Close-->
              <div id="kt_modal_add_gc_close" class="btn btn-icon btn-sm btn-active-icon-primary">
                     <i class="ki-duotone ki-cross fs-1">
                            <span class="path1"></span>
                            <span class="path2"></span>
                     </i>
              </div>
              <!--end::Close-->
       </div>
       <!--end::Modal header-->
       <!--begin::Modal body-->
       <div class="modal-body py-10 px-lg-17">
              <!--begin::Scroll-->
              <div class="mh-375px scroll-y me-n7 pe-7"><!--  -->
                     <!--begin::Input group-->
                     <div class="fv-row mb-7">
                            <!--begin::Label-->
                            <label class="fs-6 fw-semibold mb-2">
                                   <span class="required">Card No</span>
                                   <span class="ms-1" data-bs-toggle="tooltip" title="Card No must be unique">
                                          <i class="ki-duotone ki-information fs-4">
                                                 <span class="path1"></span>
                                                 <span class="path2"></span>
                                                 <span class="path3"></span>
                                          </i>
                                   </span>
                            </label>
                            <!--end::Label-->
                            <!--begin::Input-->
                            <div class="input-group mb-2">
                                   <input type="number" class="form-control space-none" placeholder="Card No" name="CardNo" value="" required="required" />
                                   <span class="input-group-text random-code"><i class="bi bi-repeat-1 fs-3"></i></span>
                         </div>
                            <!--end::Input-->
                     </div>
                     <!--end::Input group-->
                     <!--begin::Input Value-->
                     <div class="fv-row mb-7">
                            <!--begin::Label-->
                            <label class="fs-6 fw-semibold mb-2">
                                   <span class="required">Value</span>
                            </label>
                            <!--end::Label-->
                            <!--begin::Input-->
                            <input type="number" min="1" step="1" class="form-control mb-2" placeholder="Card Value" name="Value" value="" required="required" />
                            <!--end::Input-->
                     </div>
                     <!--end::Input Value-->
                     <!--begin::Input Price-->
                     <div class="fv-row mb-7">
                            <!--begin::Label-->
                            <label class="fs-6 fw-semibold mb-2">
                                   <span class="required">Price</span>
                            </label>
                            <!--end::Label-->
                            <!--begin::Input-->
                            <input type="number" min="1" step="1" class="form-control mb-2" placeholder="Card Value" name="Price" value="" required="required" />
                            <!--end::Input-->
                     </div>
                     <!--end::Input Price-->

                     <!--begin::Input Expiry-->
                     <div class="fv-row mb-7">
                        <!--begin::Label-->
                        <label class="fs-6 fw-semibold mb-2">
                               <span class="required">Expiry Date</span>
                        </label>
                        <!--end::Label-->
                        <!--begin::Input-->
                        <div class="input-group ps-1 mb-2 flatpickr" id="ExpDate">
                          <input type="date" name="ExpiryDate" value="" class="form-control rounded-start" placeholder="Expiry Date" required="required" data-input>
                          <span class="input-group-text" data-toggle>
                            <i class="fa fa-calendar"></i>
                          </span>
                          <span class="input-group-text" data-clear>
                            <i class="fa fa-times"></i>
                          </span>
                        </div>
                        <!--end::Input-->
                     </div>
                     <!--end::Input Expiry-->

                     <!--begin::Input group-->
                     <div class="fv-row mb-7">
                            <!--begin::Label-->
                            <label class="required fs-6 fw-semibold mb-2">Customer</label>
                            <!--end::Label-->
                            <!--begin::Select-->
                            <select name="CustomerGc" id="CustomerGc" class="form-select mb-2" data-control="select2" data-dropdown-parent="#kt_modal_add_gc" data-hide-search="false" data-placeholder="Select a customer" data-allow-clear="true" required="required">
                            </select>
                            <!--end::Select-->
                     </div>
                     <!--end::Input group-->
                   
              </div>
              <!--end::Scroll-->
       </div>
       <!--end::Modal body-->
       <!--begin::Modal footer-->
       <div class="modal-footer flex-center">
              <!--begin::Button-->
              <button type="reset" id="kt_modal_add_gc_cancel" class="btn btn-light me-3">Discard</button>
              <!--end::Button-->
              <!--begin::Button-->
              <button type="submit" id="kt_modal_add_gc_submit" class="btn btn-primary">
                     <span class="indicator-label">Submit</span>
                     <span class="indicator-progress">Please wait... 
                     <span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
              </button>
              <!--end::Button-->
       </div>
       <!--end::Modal footer-->
</form>
<!--end::Form-->
</div>
  </div>
  <!--end::Modal dialog-->
</div>
<script type="text/javascript">
$(document).ready(function(){
$("input, textarea").on("paste", function() {
  $(this).val($.trim($(this).val()));
});
$("input, textarea").on("keypress", function(e) {
  var startPos = e.currentTarget.selectionStart;
  if (e.which === 32 && startPos==0)
    e.preventDefault();
});
$("input, textarea").on("blur", function(e) {
   $(this).val($.trim($(this).val()));
});

$(".space-none").keypress(function( e ) {
  if(e.which === 32) 
  return false;
});

$("#ExpDate").flatpickr({
    enableTime: false,        // Enable time picker
    /*dateFormat: "Y-m-d h:i K",*/  // h = 12-hour, K = AM/PM
    dateFormat: "Y-m-d", // Format: 2025-08-17
    altInput: true,
    altFormat: "d/m/Y",    // user sees
    defaultDate: new Date(),  // Optional: current date & time as default
    minDate: "today",
    allowInput: true,           // allow typing/editing
    wrap: true,   // enables calendar icon toggle
    plugins: [new confirmDatePlugin({
    confirmText: "",     // close button text
    showAlways: false,        // show only when calendar is open
    showClear: true            // enable Clear button
  })]
});

/*begin:: Generate Gift Card Code*/
$('.random-code').on('click', function() {
    $(this).html('<i class="fa fa-refresh fa-spin"></i>');
    $('.tooltip').empty();
    $(this).next('div').empty();//Remove red color 'Card no. is required and recommended to be unique.'
    $.ajax({
        url: 'pages/giftcard-code.php',
        method: 'GET',
        success: function(data) {
            $("input[name=CardNo]").val($.trim(data)).focus();
            $('.random-code').html('<i class="bi bi-repeat-1 fs-3 text-success"></i>');
        },
        error: function() {
            alert("Error generating code.");
            $('.random-code').html('<i class="bi bi-repeat-1 fs-3"></i>');
        }
    });
});
/*end:: Generate Gift Card Code*/

// Prevent form submission if barcode scan
$("input[name=CardNo]").on('keypress', function(e) {
    if (e.which === 13) {
        e.preventDefault();
    }
});

$("#CustomerGc").select2({
    placeholder: 'Search for a customer',
    dropdownParent: $('#kt_modal_add_gc'),
    ajax: {
        url: 'pages/customer-search.php',
        dataType: 'json',
        delay: 250,
        data: function (params) {
            return {
                q: params.term // search term
            };
        },
        processResults: function (data) {
            return {
                results: data
            };
        },
        cache: true
    },
    minimumInputLength: 2
});

});
</script>
<script type="text/javascript">
(function($){ 

/*begin::Gift Card Code unique*/
let var3;
$("input[name=CardNo]").on("change blur", function() {
  var3=1;
  if($(this).val()){
    $(".random-code").html('<i class="fa fa-refresh fa-spin"></i>');
    $.get('pages/giftcard-verify.php?q=' + $(this).val(), function(data) {
      if(data.trim()==0){
        var3=0;
        $(".random-code").html('<i class="bi bi-repeat-1 fs-3 text-success" data-bs-toggle="tooltip" data-bs-title="This gift card code is availabe."></i>');
      } else {
        $(".random-code").html('<i class="bi bi-repeat-1 fs-3 text-danger" data-bs-toggle="tooltip" data-bs-title="This gift card code is already exist."></i>');
      }
      $('[data-bs-toggle="tooltip"]').tooltip();
    });
  }
  else {
     $(".random-code").html('<i class="bi bi-repeat-1 fs-3"></i>');
  }
});
/*end::Gift Card Code unique*/

"use strict";

// Class definition
var KTModalUnitAdd = function () {
    var submitButton;
    var cancelButton;
       var closeButton;
    var validator;
    var form;
    var modal;

    // Init form inputs
    var handleForm = function () {
        // Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/
              
              validator = FormValidation.formValidation(
                     form,
                     {
                            fields: {
                    'CardNo': {
                                   validators: {
                                          notEmpty: {
                                                 message: 'Card no. is required and recommended to be unique'
                                          }
                                   }
                                   },
                                   'Value': {
                                          validators: {
                                                 notEmpty: {
                                                        message: 'Value is required'
                                                 }
                                          }
                                   },
                                   'Price': {
                                          validators: {
                                                 notEmpty: {
                                                        message: 'Price is required'
                                                 }
                                          }
                                   },
                                   'ExpiryDate': {
                                          validators: {
                                                 notEmpty: {
                                                        message: 'Expiry date is required'
                                                 }
                                          }
                                   },
                                   'CustomerGc': {
                                          validators: {
                                                 notEmpty: {
                                                        message: 'Customer is required'
                                                 }
                                          }
                                   },
                                },
                            plugins: {
                                   trigger: new FormValidation.plugins.Trigger(),
                                   bootstrap: new FormValidation.plugins.Bootstrap5({
                                          rowSelector: '.fv-row',
                        eleInvalidClass: '',
                        eleValidClass: '',
                                   })
                            }
                     }
              );

              $(form.querySelector('[name="CustomerGc"]')).on('change', function () {
                  // Revalidate the field when an option is chosen
                  validator.revalidateField('CustomerGc');
              });

              // Action buttons
              submitButton.addEventListener('click', function (e) {
                     e.preventDefault();

                     if(var3==1){
                    Swal.fire({
                                   text: "Sorry, This gift card no. already exist.",
                                   icon: "error",
                                   draggable: true,
                                   buttonsStyling: !1,
                                   confirmButtonText: "Ok, got it!",
                                   customClass: {
                                          confirmButton: "btn btn-primary"
                                   }
                          }).then(function(t) {
                                   //alert("Raju");
                                    setTimeout(function () {
                                    let SuppFoc = $("input[name=CardNo]");
                                    KTUtil.scrollTop(SuppFoc.offset().top);
                                    let SuppLen = SuppFoc.val().length;
                                    SuppFoc[0].focus();
                                    SuppFoc[0].setSelectionRange(len, len);
                               }, 500);
                            });
                        return false;
                   }

                     // Validate form before submit
                     if (validator) {
                            validator.validate().then(function (status) {
                                   //console.log('validated!');

                                   if (status == 'Valid') {
                                          submitButton.setAttribute('data-kt-indicator', 'on');
                                          submitButton.disabled = true;

                                          /*----------------------*/

                                            let GcNo = $("input[name=CardNo]").val();
                                            let GcQty = 1;
                                            let GcValue = parseFloat($("input[name=Value]").val());
                                            let GcPrice = parseFloat($("input[name=Price]").val());
                                            let GcExpDate = $("input[name=ExpiryDate]").val();
                                            let GcCuId = $("select[name=CustomerGc]").val();
                                            let GcDisc = 0;
                                            let GcTotal = GcPrice;

                                             // Prevent duplicate gift card
                                            if ($("#productTable tbody tr[data-giftcard='" + GcNo + "']").length) {
                                              //alert("Gift card number already added!");
                                              Swal.fire({
                                                    text: "This gift card number already added!.",
                                                    icon: "error",
                                                    buttonsStyling: false,
                                                    timer: 2000,
                                                    confirmButtonText: "Ok, got it!",
                                                    customClass: {
                                                        confirmButton: "btn btn-primary",
                                                    }
                                                });
                                              submitButton.removeAttribute('data-kt-indicator');
                                              submitButton.disabled = false;
                                              return false;
                                            }

                                            let GcRow = $(`
                                              <tr data-giftcard="${GcNo}">
                                                <td></td>
                                                <td>Gift card(${GcNo})<input type="hidden" name="GiftCardNo[]" value="${GcNo}"></td>
                                                <td class="p-0"><input type="number" min="1" max="1" step="1" name="GcQty[]" value="${GcQty}" class="form-control form-control-sm qtyInput"></td>
                                                <td class="price">${GcPrice.toFixed(2)}<input type="hidden" name="GcValue[]" value="${GcValue}"><input type="hidden" name="GcPrice[]" value="${GcPrice}"></td>
                                                <td class="p-0"><input type="number" min="0" step="any" name="GcDisc[]" value="${GcDisc}" class="form-control form-control-sm discountInput"><input type="hidden" name="GcExpDate[]" value="${GcExpDate}"><input type="hidden" name="CustomerGc[]" value="${CustomerGc}"></td>
                                                <td class="text-end total">${GcTotal.toFixed(2)}</td>
                                                <td><i class="bi bi-x-circle fs-2 remove-item"></i></td>
                                              </tr>
                                            `);
                                            $("#productTable tbody").append(GcRow);
                                            updateGrandTotal();
                                            updateRowNumbers();
                                            form.reset();
                                            modal.hide();

                                          /*----------------------*/
                                                                                   
                                   } 
                            });
                     }
              });

        cancelButton.addEventListener('click', function (e) {
            e.preventDefault();

            Swal.fire({
                text: "Are you sure you would like to cancel?",
                icon: "warning",
                showCancelButton: true,
                buttonsStyling: false,
                confirmButtonText: "Yes, cancel it!",
                cancelButtonText: "No, return",
                customClass: {
                    confirmButton: "btn btn-primary",
                    cancelButton: "btn btn-active-light"
                }
            }).then(function (result) {
              
                if (result.value) {
                     //$("#kt_modal_add_gc").modal("hide");
                    form.reset(); // Reset form  
                    modal.hide(); // Hide modal                       
                } else if (result.dismiss === 'cancel') {
                    Swal.fire({
                        text: "Your form has not been cancelled!.",
                        icon: "error",
                        buttonsStyling: false,
                        timer: 2000,
                        confirmButtonText: "Ok, got it!",
                        customClass: {
                            confirmButton: "btn btn-primary",
                        }
                    });
                }
            });
        });

              closeButton.addEventListener('click', function(e){
                     e.preventDefault();

            Swal.fire({
                text: "Are you sure you would like to cancel?",
                icon: "warning",
                showCancelButton: true,
                buttonsStyling: false,
                confirmButtonText: "Yes, cancel it!",
                cancelButtonText: "No, return",
                customClass: {
                    confirmButton: "btn btn-primary",
                    cancelButton: "btn btn-active-light"
                }
            }).then(function (result) {
                if (result.value) {
                    form.reset(); // Reset form  
                    modal.hide(); // Hide modal                       
                } else if (result.dismiss === 'cancel') {
                    Swal.fire({
                        text: "Your form has not been cancelled!.",
                        icon: "error",
                        buttonsStyling: false,
                        timer: 2000,
                        confirmButtonText: "Ok, got it!",
                        customClass: {
                            confirmButton: "btn btn-primary",
                        }
                    });
                }
            });
              })
    }

    return {
        // Public functions
        init: function () {
            // Elements
            modal = new bootstrap.Modal(document.querySelector('#kt_modal_add_gc'));

            form = document.querySelector('#kt_modal_add_gc_form');
            submitButton = form.querySelector('#kt_modal_add_gc_submit');
            cancelButton = form.querySelector('#kt_modal_add_gc_cancel');
                     closeButton = form.querySelector('#kt_modal_add_gc_close');

            handleForm();
            
        }
    };
}();

// On document ready
KTUtil.onDOMContentLoaded(function () {
       KTModalUnitAdd.init();
});    
})(jQuery);
</script>
