<link href="assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css"/>
 <!-- Modal HTML -->
 <div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content"><!-- mw-650px -->
      </div>
    </div>
  </div>
  <!-- Modal HTML -->
<!--begin::Content-->
<div id="kt_app_content" class="app-content flex-column-fluid">
	<!--begin::Content container-->
	<div id="kt_app_content_container" class="app-container container-xxl">
		<!--begin::Card-->
		<div class="card">
			<!--begin::Heading-->
			<div class="text-center mt-4">
				<!--begin::Title-->
				<h1 class="mt-2">Gift Card List</h1>
				<!--end::Title-->
			</div>
			<!--end::Heading-->
			<!--begin::Card header-->
			<div class="card-header border-0 pt-2">
				<!--begin::Card title-->
				<div class="card-title">
					<!--begin::Search-->
					<div class="d-flex align-items-center position-relative my-1">
						<i class="ki-duotone ki-magnifier fs-3 position-absolute ms-5">
							<span class="path1"></span>
							<span class="path2"></span>
						</i>
						<input type="text" data-kt-filter="search" class="form-control form-control-solid w-250px ps-14" placeholder="Search Report" />
					</div>
					<!--end::Search-->
					<!--begin::Export buttons-->
					<div id="kt_datatable_gc_1_export" class="d-none"></div>
					<!--end::Export buttons-->
				</div>
				<!--begin::Card title-->
				<!--begin::Card toolbar-->
				<div class="card-toolbar">
					<!--begin::Export dropdown-->
					<button type="button" class="btn btn-light-primary" data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">
						<i class="ki-duotone ki-exit-down fs-2"><span class="path1"></span><span class="path2"></span></i>
						Export Report
					</button>
					<!--begin::Menu-->
					<div id="kt_datatable_gc_export_menu" class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-600 menu-state-bg-light-primary fw-semibold fs-7 w-200px py-4" data-kt-menu="true">
						<!--begin::Menu item-->
						<div class="menu-item px-3">
							<a href="#" class="menu-link px-3" data-kt-export="copy">
							Copy to clipboard
							</a>
						</div>
						<!--end::Menu item-->
						<!--begin::Menu item-->
						<div class="menu-item px-3">
							<a href="#" class="menu-link px-3" data-kt-export="excel">
							Export as Excel
							</a>
						</div>
						<!--end::Menu item-->
						<!--begin::Menu item-->
						<div class="menu-item px-3">
							<a href="#" class="menu-link px-3" data-kt-export="csv">
							Export as CSV
							</a>
						</div>
						<!--end::Menu item-->
						<!--begin::Menu item-->
						<div class="menu-item px-3">
							<a href="#" class="menu-link px-3" data-kt-export="pdf">
							Export as PDF
							</a>
						</div>
						<!--end::Menu item-->
					</div>
					<!--end::Menu-->
					<!--end::Export dropdown-->

					<!--begin::Hide default export buttons-->
					<div id="kt_datatable_gc_buttons" class="d-none"></div>
					<!--end::Hide default export buttons-->
				</div>
				<!--end::Card toolbar-->
			</div>
			<!--end::Card header-->
			<!--begin::Card body-->
			<div class="card-body pt-0">
				<!--begin::Table-->
				<table class="table table-striped table-row-bordered align-middle gy-5 gs-7 border rounded" id="kt_datatable_gc">
					<thead>
						<!--begin::Table row-->
						<tr class="text-start text-gray-500 fw-bold fs-7 text-uppercase">
							<th class="text-center">#</th>
							<th class="text-start min-w-150px">Card No</th>
							<th class="min-w-150px text-end ">Value</th>
							<th class="min-w-150px">Expire Date</th>
							<th class="min-w-150px text-end ">Balance</th>
							<th class="min-w-150px">Customer</th>
							<th class="text-end min-w-70px">Actions</th>
						</tr>
						<!--end::Table row-->
					</thead>
					<tbody class="fw-semibold text-gray-600">
					<?php
				    $s=0;
				    $result01=mysqli_query($con, "select * from mws_gift_cards as a  left join mws_customer as b on a.CuId=b.CuId where a.GcStatus=1 order by a.GcId ASC");
				    while($field01=mysqli_fetch_array($result01))
				    { $s++;
				    ?>
						<tr class="text-center">
							<td><?php echo $s ?></td>
							<td class="text-start pe-0" data-kt-gc-filter="gc_name">
								<a href="#" data-url="pages/product-details+.php?p=<?php echo $field01['GcId'] ?>" class="text-gray-900 text-hover-primary view-modal"><?php echo $field01['GcCardNo'];?></a>
							</td>
							<td class="text-end pe-0"><?php echo $field01['GcValue'] ?></td>
							<td class="text-start pe-0"><?php echo date("d/m/Y", strtotime($field01['GcExpiry'])); ?></td>
							<td class="text-end pe-0"><?php echo $field01['GcBalance'] ?></td>
							<td class="text-start pe-0"><?php echo $field01['CuCompany'] ?></td>
							<td class="text-end py-2">
								<a href="#" class="btn btn-sm btn-light btn-flex btn-center btn-active-light-primary" data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">Actions 
								<i class="ki-duotone ki-down fs-5 ms-1"></i></a>
								<!--begin::Menu-->
								<div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-600 menu-state-bg-light-primary fw-semibold fs-7 w-125px py-2" data-kt-menu="true">
									<!--begin::Menu item-->
									<!-- <div class="menu-item px-2">
										<a href="#" class="menu-link px-3 py-1"><i class="bi bi-pencil-square"></i>&nbsp;Edit</a>
									</div> -->
									<!--end::Menu item-->
									<!--begin::Menu item-->
									<!-- <div class="menu-item px-2">
										<a href="#" class="menu-link px-3 py-1" data-gc-id="<?php echo $field01['GcId'] ?>" data-kt-gc-filter="delete_row"><i class="bi bi-trash3"></i>&nbsp;Delete</a>
									</div> -->
									<!--end::Menu item-->
								</div>
								<!--end::Menu-->
							</td>
						</tr>
					<?php } ?>
					</tbody>
				</table>
				<!--end::Table-->
			</div>
			<!--end::Card body-->
		</div>
		<!--end::Card-->
	</div>
	<!--end::Content container-->
</div>
<!--end::Content-->

<script src="assets/plugins/custom/datatables/datatables.bundle.js"></script>
<script>
$("input, textarea").on("paste", function() {
  $(this).val($.trim($(this).val()));
});
$("input, textarea").on("keypress", function(e) {
  var startPos = e.currentTarget.selectionStart;
  if (e.which === 32 && startPos==0)
    e.preventDefault();
});
$("input, textarea").on("blur", function(e) {
   $(this).val($.trim($(this).val()));
});

$('.view-modal').on('click', function(e){
  e.preventDefault();
  $('#staticBackdrop').modal('show');
  $("#staticBackdrop .modal-content").html('<center><i class="fa fa-refresh fa-spin"></i> loading...</center>');
  $('#staticBackdrop .modal-content').load($(this).data("url"));
});

"use strict";

// Class definition
var KTDatatablesGc = function () {
    // Shared variables
    var table;
    var datatable;

    // Private functions
    var initDatatable = function () {
        // Set date data order
        const tableRows = table.querySelectorAll('tbody tr');

        tableRows.forEach(row => {
            const dateRow = row.querySelectorAll('td');
            const realDate = moment(dateRow[1].innerHTML, "DD MMM YYYY, LT").format(); // select date from 2nd column in table
            dateRow[1].setAttribute('data-order', realDate);
        });

        // Init datatable --- more info on datatables: https://datatables.net/manual/
        datatable = $(table).DataTable({
            "info": false,
            'order': [],
            'columnDefs': [{
					orderable: !1,
					targets: 6
				}],
            'pageLength': 10,
        });
    }

    // Hook export buttons
    var exportButtons = () => {
        const documentTitle = 'Gift Card List';
        var buttons = new $.fn.dataTable.Buttons(table, {
            buttons: [
                {
                    extend: 'copyHtml5',
                    title: documentTitle
                },
                {
                    extend: 'excelHtml5',
                    title: documentTitle
                },
                {
                    extend: 'csvHtml5',
                    title: documentTitle
                },
                {
                    extend: 'pdfHtml5',
                    title: documentTitle
                }
            ]
        }).container().appendTo($('#kt_datatable_gc_buttons'));

        // Hook dropdown menu click event to datatable export buttons
        const exportButtons = document.querySelectorAll('#kt_datatable_gc_export_menu [data-kt-export]');
        exportButtons.forEach(exportButton => {
            exportButton.addEventListener('click', e => {
                e.preventDefault();

                // Get clicked export value
                const exportValue = e.target.getAttribute('data-kt-export');
                const target = document.querySelector('.dt-buttons .buttons-' + exportValue);

                // Trigger click event on hidden datatable export buttons
                target.click();
            });
        });
    }

    // Search Datatable --- official docs reference: https://datatables.net/reference/api/search()
    var handleSearchDatatable = () => {
        const filterSearch = document.querySelector('[data-kt-filter="search"]');
        filterSearch.addEventListener('keyup', function (e) {
            datatable.search(e.target.value).draw();
        });
    }


    // Delete cateogry
    var handleDeleteRows = () => {
    	// Select all delete buttons
        const deleteButtons = table.querySelectorAll('[data-kt-gc-filter="delete_row"]');
        deleteButtons.forEach(d => {
            // Delete button on click
            d.addEventListener('click', function (e) {
                e.preventDefault();
                // Select parent row
                const parent = e.target.closest('tr');

                // Get category name
                const gcName = parent.querySelector('[data-kt-gc-filter="gc_name"]').innerText;

                const gcid = this.getAttribute('data-gc-id');

                // SweetAlert2 pop up --- official docs reference: https://sweetalert2.github.io/
                Swal.fire({
                    text: "Are you sure you want to delete " + gcName + "?",
                    icon: "warning",
                    showCancelButton: true,
                    buttonsStyling: false,
                    confirmButtonText: "Yes, delete!",
                    cancelButtonText: "No, cancel",
                    customClass: {
                        confirmButton: "btn fw-bold btn-danger",
                        cancelButton: "btn fw-bold btn-active-light-primary"
                    }
                }).then(function (result) {
                    if (result.value) {

                        axios.get('pages/sales-delete.php', {
						  params: {
						    id: gcid,
						    status: 1
						  }
						})
						.then(response => {
						  //console.log(response.data);
						  //alert(response.data.state);
						  Swal.fire({
	                            text: "You have deleted " + gcName + "!.",
	                            icon: "success",
	                            buttonsStyling: false,
	                            confirmButtonText: "Ok, got it!",
	                            customClass: {
	                                confirmButton: "btn fw-bold btn-primary",
	                            }
	                        }).then(function () {
	                            // Remove current row
	                            datatable.row($(parent)).remove().draw();
	                        });

						})
						.catch(error => {
						  //console.error(error);
						});

                    } else if (result.dismiss === 'cancel') {
                        Swal.fire({
                            text: gcName + " was not deleted.",
                            icon: "error",
                            buttonsStyling: false,
                            confirmButtonText: "Ok, got it!",
                            customClass: {
                                confirmButton: "btn fw-bold btn-primary",
                            }
                        });
                    }
                });
            })
        });
    }

    // Public methods
    return {
        init: function () {
            table = document.querySelector('#kt_datatable_gc');

            if ( !table ) {
                return;
            }

            initDatatable();
            exportButtons();
            handleSearchDatatable();
            handleDeleteRows();
        }
    };
}();

// On document ready
KTUtil.onDOMContentLoaded(function () {
    KTDatatablesGc.init();
});

</script>
