<style>
@media print {
  * {
    -webkit-print-color-adjust: exact !important;
    print-color-adjust: exact !important;
  }
  @page {
    margin: 0;
  }
  body * {
    visibility: hidden !important;
  }
  .print-area, .print-area * {
    visibility: visible !important;
  }
  /* Position it correctly for printing */
  .print-area {
    margin-top: -665px;
    position: absolute;
    left: 0;
    top: 0;
    width:100%;
  }
}
</style>

<!--AUTO SUGGEST-->
<link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">

<!--begin::Content-->
<div id="kt_app_content" class="app-content flex-column-fluid">
	<!--begin::Content container-->
	<div id="kt_app_content_container" class="app-container container-xxl">
		<!--begin::Contact-->
		<div class="card">
			<div class="card-header">
		        <h1 class="card-title fw-bold text-gray-900"><i class="fas fa-plus"></i>&nbsp;Print Barcode/Label</h1>
		    </div>
			<!--begin::Body-->
			<div class="card-body p-lg-17">
				<!--begin::Row-->
				<div class="row mb-3">
					<!--begin::Col-->
					<div class="col-md-6 pe-lg-10">
					    <!--begin::Input Product Code/Name-->
						<div class="mb-5 fv-row">
							<!--begin::Label-->
							<label class="required form-label">Product Name/Code</label>
							<!--end::Label-->
							<!--begin::Input-->
							<div class="input-group mb-2">
								<input type="search" maxlength="256" name="Product" value="" id="Product" class="form-control" placeholder="Product Name/Code" autofocus/>
								<span class="input-group-text"><i class="bi bi-upc-scan fs-2"></i></span>
						    </div>
							<!--end::Input-->
						</div>
						<!--end::Input Product Code/Name-->
					</div>
					<!--end::Col-->

				</div>
				<form action="" method="post" id="kt_barcode_form" class="form">
				<div class="table-responsive">
					<table id="barcode-item" class="table table-bordered table-hover  align-middle">
						<thead class="table-dark">
							<tr class="fw-bold fs-6 text-gray-800">
								<th width="5%">#</th>
								<th width="40%">Product Name(Code)</th>
								<th width="30%">Quantity</th>
								<th width="20%">Barcode Type</th>
								<th width="5%" class="text-center"><i class="bi bi-trash3 fs-2 text-danger"></i></th>
							</tr>
						</thead>
						<tbody>
						</tbody>
					</table>
				</div>
				<!--begin::Row-->
				<div class="row mb-3">
					<!--begin::Col-->
					<div class="col-md-6 pe-lg-10">
					    <!--begin::Select Sheet setting-->
						<div class="mb-5 fv-row">
							<!--begin::Label-->
							<label class="required form-label">Sheet setting</label>
							<!--end::Label-->
							<!--begin::Select-->
							<div class="input-group mb-2 flex-nowrap">
							  <div class="overflow-hidden flex-grow-1">
								<select name="Sheet" class="form-select rounded-end-0" data-control="select2" data-hide-search="false" data-placeholder="Select an option" data-allow-clear="true" required="required">
                 <option></option>
                 <option value="40">40 per sheet (a4) (Label size: 1.799" x 1.003")</option>
								<option value="30">30 per sheet (Label size: 2.625" x 1")</option>
								<option value="24">24 per sheet (a4) (Label size: 2.48" x 1.334")</option>
								<option value="20">20 per sheet (Label size: 4" x 1")</option>
								<option value="18">18 per sheet (a4) (Label size: 2.5" x 1.835")</option>
								<option value="14">14 per sheet (Label size: 4" x 1.33")</option>
								<option value="12">12 per sheet (a4) (Label size: 2.5" x 2.834")</option>
								<option value="10">10 per sheet (Label size: 4" x 2")</option>
								<option value="1">Continuous feed</option>
              </select>
              </div>
								<span class="input-group-text"><i class="bi bi-gear fs-2"></i></span>
						    </div>
							<!--end::Select-->
						</div>
						<!--end::Select Sheet setting-->
						<!--begin::Dimension-->
					   <div class="cf-area">
						<div class="d-flex flex-wrap gap-5 mb-5">
							<!--begin::Input Width-->
							<div class="fv-row w-100 flex-md-root">
								<!--begin::Label-->
								<label class="required form-label">Width</label>
								<!--end::Label-->
								<!--begin::Input-->
								<div class="input-group mb-2">
									<input type="number" min="1" step="any" name="Width" value="" class="form-control" placeholder="Width" required="required"/>
									<span class="input-group-text">Inches</span>
							    </div>
								<!--end::Input-->
							</div>
							<!--end::Input Width-->
							<!--begin::Input Height-->
							<div class="fv-row w-100 flex-md-root">
								<!--begin::Label-->
								<label class="required form-label">Height</label>
								<!--end::Label-->
								<!--begin::Input-->
								<div class="input-group mb-2">
									<input type="number" min="1" step="any" name="Height" value="" class="form-control" placeholder="Height" required="required" />
									<span class="input-group-text">Inches</span>
							    </div>
								<!--end::Input-->
							</div>
							<!--end::Input Height-->
						</div>
					   </div>
						<!--end:Dimension-->
					</div>
					<!--end::Col-->

				</div>
				<!--end::Row-->
                
                <!--begin::Print information-->
                <div class=" mb-2"><label class="form-label">Print text</label></div>
				<div class="form-check form-check-inline form-switch form-check-custom form-check-success form-check-solid">
				    <input name="BusinessName" class="form-check-input " type="checkbox" value="1" id="kt_flexSwitchCustomDefault_1_1"/>
				    <label class="form-check-label" for="kt_flexSwitchCustomDefault_1_1">
				        Business Name
				    </label>
				</div>

				<div class="form-check form-check-inline form-switch form-check-custom form-check-danger form-check-solid">
				    <input name="ProductName" class="form-check-input " type="checkbox" value="2" id="kt_flexSwitchCustomDefault_1_2"/>
				    <label class="form-check-label" for="kt_flexSwitchCustomDefault_1_2">
				        Product Name
				    </label>
				</div>

				<div class="form-check form-check-inline form-switch form-check-custom form-check-warning form-check-solid">
				    <input name="Price" class="form-check-input " type="checkbox" value="3" id="kt_flexSwitchCustomDefault_1_3"/>
				    <label class="form-check-label" for="kt_flexSwitchCustomDefault_1_3">
				        Price
				    </label>
				</div>
				<!--end::Print information-->

				<!--begin::Row-->
				<div class="row mt-4 mb-3">
					<!--begin::Col-->
					<div class="col-md-6 pe-lg-10">
					    <!--begin::Input Barcode color-->
						<div class="mb-5 fv-row">
							<!--begin::Label-->
							<label class="required form-label">Barcode color</label>
							<!--end::Label-->
							<!--begin::Input-->
							<div class="input-group mb-2">
								<input type="color" name="BarcodeColor" value="#000000" id="BarcodeColor" class="form-control form-control-lg" placeholder="Barcode color"/>
								<span class="input-group-text"><i class="bi bi-upc fs-1"></i></span>
						    </div>
							<!--end::Input-->
						</div>
						<!--end::Input Barcode color-->
					</div>
					<!--end::Col-->

				</div>
				<!--end::Row-->

				<div class="d-flex justify-content-end">
					<!--begin::Submit-->
					<button type="submit" name="GenerateBtn" class="btn btn-primary" id="kt_barcode_submit_button">
						<!--begin::Indicator label-->
						<span class="indicator-label">Generate</span>
						<!--end::Indicator label-->
						<!--begin::Indicator progress-->
						<span class="indicator-progress">Please wait... 
						<span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
						<!--end::Indicator progress-->
					</button>
					<!--end::Submit-->
				</div>

				</form>
				<!--end::Form-->
			</div>
			<!--end::Body-->
		</div>
		<!--end::Contact-->
		<?php
		    /*https://github.com/picqer/php-barcode-generator*/
			require '../barcode/vendor/autoload.php';
			use Picqer\Barcode\BarcodeGeneratorHTML;
			$generator = new BarcodeGeneratorHTML();
		?>
		<?php if ($_SERVER['REQUEST_METHOD'] === 'POST') { ?>
		<!--begin::Barcode Label-->
		<div class="card mt-2">
			<div class="card-body p-lg-10">
				<div class="print-area">
				<?php
				     /*Static Barcode Print Check*/
                    /*function generateBarcode($type, $digits, $numberSystem = '0') {

				    $digits = preg_replace('/\D/', '', $digits);

				    switch (strtoupper($type)) {
				        case 'UPC_A':
				            return $digits . calculateCheckDigit($digits);

				        case 'EAN_13':
				            return $digits . calculateCheckDigit($digits);

				        case 'EAN_8':
				            return $digits . calculateCheckDigit($digits);

				        case 'UPC_E':
				            $lastDigit = (int)$digits[5];
				            switch ($lastDigit) {
				                case 0:
				                case 1:
				                case 2:
				                    $upca = $numberSystem . substr($digits, 0, 2) . $lastDigit . "0000" . substr($digits, 2, 3);
				                    break;
				                case 3:
				                    $upca = $numberSystem . substr($digits, 0, 3) . "00000" . substr($digits, 3, 2);
				                    break;
				                case 4:
				                    $upca = $numberSystem . substr($digits, 0, 4) . "00000" . $digits[4];
				                    break;
				                default:
				                    $upca = $numberSystem . substr($digits, 0, 5) . "0000" . $lastDigit;
				                    break;
				            }

				            $checkDigit = calculateCheckDigit($upca);
				            return $numberSystem . $digits . $checkDigit;
				    }
				}

				function calculateCheckDigit($codeWithoutCheckDigit) {
				    $len = strlen($codeWithoutCheckDigit);
				    $sumOdd = 0;
				    $sumEven = 0;
				    for ($i = $len - 1, $pos = 1; $i >= 0; $i--, $pos++) {
				        if ($pos % 2 === 0) {
				            $sumEven += (int)$codeWithoutCheckDigit[$i];
				        } else {
				            $sumOdd += (int)$codeWithoutCheckDigit[$i];
				        }
				    }
				    $total = ($sumOdd * 3) + $sumEven;
				    $modulo = $total % 10;
				    return ($modulo === 0) ? 0 : 10 - $modulo;
				}


					$colorRed = "#000000";
					echo $barcodeNumber = generateBarcode('UPC_E', '792052');  
					$barcode = $generator->getBarcode($barcodeNumber, $generator::TYPE_UPC_E, 1, 30, $colorRed);
					echo $barcode;*/

					/*switch ($type) {
		                case 'UPC-A':
		                    $barcode = $generator->getBarcode($barcodeNumber, $generator::TYPE_UPC_A, 3, 50, $colorRed);
		                    break;
		                case 'EAN-8':
		                    $barcode = $generator->getBarcode($barcodeNumber, $generator::TYPE_EAN_8);
		                    break;
		                case 'Code128':
		                    $barcode = $generator->getBarcode($barcodeNumber, $generator::TYPE_CODE_128);
		                    break;
		            }*/
                    
                    /*use Picqer\Barcode\BarcodeGeneratorPNG;
		            $barcodeImg = 'data:image/png;base64,' . base64_encode($barcode);*/
				?>
				<div>
				<?php
				 $Sheet=$_POST['Sheet'];
				 $BarcodeColor=$_POST['BarcodeColor'];

				 $BusinessName=""; $ProductName=""; $Price="";
				 if (isset($_POST['BusinessName'])) { $BusinessName=$_POST['BusinessName']; }
				 if (isset($_POST['ProductName'])) { $ProductName=$_POST['ProductName']; }
				 if (isset($_POST['Price'])) { $Price=$_POST['Price']; }
                 //$Sheet=1;
                 if($Sheet>1){

                 switch ($Sheet) {
	                case '40':
	                    $SheetSize=40;
	                    break;
	                case '30':
	                    $SheetSize=30;
	                    break;
	                case '24':
	                    $SheetSize=24;
	                    break;
	                case '20':
	                    $SheetSize=20;
	                    break;
	                case '18':
	                    $SheetSize=18;
	                    break;
	                case '14':
	                    $SheetSize=14;
	                    break;
	                case '12':
	                    $SheetSize=12;
	                    break;
	                case '24':
	                    $SheetSize=10;
	                    break;
	             }
                 //$SheetSize=40;
				 $totalLabels = array_sum($_POST['BcQty']);
				 $labelsPerSheet = $SheetSize;
				 $sheets = ceil($totalLabels / $labelsPerSheet);

                  $labelIndex = 1; // continuous numbering
				  $labelCount = 0; // Tracks how many labels are on the current sheet
				  ?>
                  <div class="barcode-sheet barcode-sheet-<?php echo $SheetSize ?>">

                  	<?php
					 foreach ($_POST['ProId'] as $key => $PrId) {
					 $BtId=$_POST['BtyId'][$key];
					 $BcQty=$_POST['BcQty'][$key];
					 $result01=mysqli_query($con,"select * from mws_product as a inner join mws_barcode_type as b on a.BtId=b.BtId WHERE a.PrId='$PrId'");
			         $field01=mysqli_fetch_array($result01);
					 $barcodeNumber = $field01['PrCode'];
					 $BtType = $field01['BtType'];
					 for ($i=0; $i <$BcQty ; $i++) { 
					 if (defined("Picqer\Barcode\BarcodeGeneratorHTML::$BtType")) {
						   $barcodeType = constant("Picqer\Barcode\BarcodeGeneratorHTML::$BtType");
					 }
					 if ($labelIndex > $totalLabels) break; // stop if all labels printed
			        ?>
			        <div class="bc-label-area bc-label-area-<?php echo $SheetSize ?>">
			        	<?php if($BusinessName!=""){ ?>
			        	<div><?php echo $BusinessName="Monarch Wholesale" ?></div>
			        	<?php } ?>
			        	<?php if($ProductName!=""){ ?>
			        	<div><?php echo $field01['PrName'] ?></div>
			        	<?php } ?>
			        	<?php if($Price!=""){ ?>
			        	<div>Price: <?php echo $field01['PrPrice'] ?></div>
			        	<?php } ?>
			        	<div><?php echo $barcode = $generator->getBarcode($barcodeNumber, $barcodeType, 1.2, 30, $BarcodeColor); ?></div>
	                    <div><strong><?php echo $field01['PrCode'] ?></strong></div>
			        </div>
			        <?php 
			          $labelIndex++; $labelCount++;
			          // If we've printed 40 labels, start a new sheet
				        if ($labelCount >= $labelsPerSheet) { 
				      ?>
				           </div><div class="barcode-sheet barcode-sheet-<?php echo $SheetSize ?>">
				      <?php  $labelCount = 0; }
			         }
			        } 
			         ?>
                   </div><!-- barcode-sheet -->
               <?php 
               /*$Sheet>1*/} else {
               	$Height=$_POST['Height'];
                $Width=$_POST['Width'];
               ?>
              <div class="cf-label-body">
               <div class="cf-label-container" style="grid-template-columns: repeat(1, <?php echo $Width ?>in);">
               <?php
			   foreach ($_POST['ProId'] as $key => $PrId) {
				 $BtId=$_POST['BtyId'][$key];
				 $BcQty=$_POST['BcQty'][$key];
				 $result01=mysqli_query($con,"select * from mws_product as a inner join mws_barcode_type as b on a.BtId=b.BtId WHERE a.PrId='$PrId'");
		         $field01=mysqli_fetch_array($result01);
				 $barcodeNumber = $field01['PrCode'];
				 $BtType = $field01['BtType'];
				 for ($i=0; $i <$BcQty ; $i++) { 
				   if (defined("Picqer\Barcode\BarcodeGeneratorHTML::$BtType")) {
					   $barcodeType = constant("Picqer\Barcode\BarcodeGeneratorHTML::$BtType");
				   }
                 ?>
                   <div class="cf-label-area" style="Width: <?php echo $Width ?>in; height: <?php echo $Height ?>in;">
                   	  <?php if($BusinessName!=""){ ?>
			        	<div><?php echo $BusinessName="Monarch Wholesale" ?></div>
			        	<?php } ?>
			        	<?php if($ProductName!=""){ ?>
			        	<div><?php echo $field01['PrName'] ?></div>
			        	<?php } ?>
			        	<?php if($Price!=""){ ?>
			        	<div>Price: <?php echo $field01['PrPrice'] ?></div>
			        	<?php } ?>
			        	<div class="cf-barcode-area"><?php echo $barcode = $generator->getBarcode($barcodeNumber, $barcodeType, 1, 25, $BarcodeColor); ?></div>
	                    <div><strong><?php echo $field01['PrCode'] ?></strong></div>
                   </div>
                 <?php
				   }
			      }
			      ?>
			   </div>
			  </div>
              <?php } ?>   
		      </div>
		    </div>
		      <!--begin::Actions-->
					<div class="d-flex justify-content-end mt-2">
					  <button class="btn btn-success fw-bold" id="btnPrint" onclick="window.print();">
					    <i class="bi bi-printer"></i> Print
					  </button>
					</div>
					<!--end::Actions-->
			</div>
			
		</div>

		<!--end::Barcode Label-->
	    <?php } ?>
	</div>
	<!--end::Content container-->
</div>
<!--end::Content-->
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
<script>
$(function() {
 $( "#Product" ).autocomplete({
    source: 'pages/product-search.php',
    delay: 250,
    autoFocus: true,
    minLength: 2,
    select: function( event, ui ) {
      event.preventDefault();
	  addItemToTable(ui.item);
	  $('#Product').val('');
	  return false;
    }
  });

 // Barcode scanner support: press Enter to add
$('#Product').keypress(function (e) {
    if (e.which === 13) {
        e.preventDefault();
        let scannedCode = $(this).val().trim();
        if (!scannedCode) return;

        $.getJSON('pages/product-search.php', { term: scannedCode }, function (data) {
            if (data.length > 0) {
                $('#Product').val('');
                addItemToTable(data[0]);
            } else {
                //alert('Product not found!');
                Swal.fire({
					text: "Sorry, Product not found!",
					icon: "error",
					draggable: true,
					buttonsStyling: false,
                    timer: 3000,
					confirmButtonText: "Ok, got it!",
					customClass: {
						confirmButton: "btn btn-primary"
					}
			     });
            }
        });
    }
});

function addItemToTable(product) {
    let exists = false;
    $('#barcode-item tbody tr').each(function() {
        let rowBarcode = $(this).find('td:eq(1) input').val(); // 2nd column is label
        if (rowBarcode === product.pid) {
            let qty = parseInt($(this).find('td:eq(2) input').val()); // Quantity column
            $(this).find('td:eq(2) input').val(qty + 1);
            exists = true;
            return false;
        }
    });
    
    if (!exists) {
        let newRow = `
            <tr>
                <td></td>
                <td>${product.label}<input type="hidden" name="ProId[]" value="${product.pid}"></td>
                <td class="p-0"><input type="number" min="0" max="100" name="BcQty[]" value="1" class="form-control form-control-sm"></td>
                <td>${product.bct}<input type="hidden" name="BtyId[]" value="${product.btid}"></td>
                <td><i class="bi bi-x-circle fs-2 remove-item"></i></td>
            </tr>`;
        $('#barcode-item tbody').append(newRow);
    }

    updateRowNumbers();
}

function updateRowNumbers() {
    $('#barcode-item tbody tr').each(function(index) {
        $(this).find('td:eq(0)').text(index + 1);
    });
}

$('#barcode-item').on('click', '.remove-item', function() {
    $(this).closest('tr').remove();
    updateRowNumbers();
});

});
</script>
<script>
$("input, textarea").on("paste", function() {
  $(this).val($.trim($(this).val()));
});
$("input, textarea").on("keypress", function(e) {
  var startPos = e.currentTarget.selectionStart;
  if (e.which === 32 && startPos==0)
    e.preventDefault();
});
$("input, textarea").on("blur", function(e) {
   $(this).val($.trim($(this).val()));
});

$('#BarcodeColor').on('input',
	function() {
	    //alert($(this).val());
	    $('.bi-upc').css({'color':$(this).val()});
	}
);

/*begin::Load CF Area*/
$(".cf-area input").prop('disabled', true);
$("select[name=Sheet]").change(function() {
 if($(this).val()==1) {
    $(".cf-area").show('slow');
    $(".cf-area input").prop('disabled', false);
   } else {
    $(".cf-area").hide('slow');
    $(".cf-area input").val(null).prop('disabled', true);
   }
});
/*end::Load CF Area*/


const submitButton = document.getElementById('kt_barcode_submit_button');
$('#kt_barcode_form').on('submit', function(e) {
    e.preventDefault()
    var form = this;
    

    if ($('[name="ProId[]"]').length==0) {
      Swal.fire({
			text: "Please, Select at least one product.",
			icon: "error",
			draggable: true,
			buttonsStyling: false,
            timer: 3000,
			confirmButtonText: "Ok, got it!",
			customClass: {
				confirmButton: "btn btn-primary"
			}
	     })
	   return false;
     }

    // Show loading indication
    submitButton.setAttribute('data-kt-indicator', 'on');

    // Disable button to avoid multiple click
    submitButton.disabled = true;
    form.submit(); // Submit form

});    

</script>