<div class="container my-5 poppins">
  <div class="row justify-content-center">
    <div class="col-md-6 col-sm-8 align-self-center">
    <!-- STEP 1: Mobile Number -->
    <h3 class="text-center text-warning pb-2">Create Account</h3>
    <div id="step1">
      <div class="card p-4 shadow rounded-3">
          <h6>Enter Mobile Number</h6>
          <input type="text" id="mobile" class="form-control" placeholder="01XXXXXXXXX" required autocomplete="off">
          <div class="invalid-feedback">Enter a valid 11-digit mobile number.</div>
          <div class="valid-feedback">Looks good!</div>
          <div class="form-text text-muted" style="font-size: 0.7rem;">You will receive an OTP on your mobile number.</div>
          <div class="d-flex justify-content-center mt-3">
              <button id="sendOtpBtn" class="btn btn-primary" type="button">Next <i class="bi bi-caret-right"></i></button>
          </div>
          <div id="msg1" class="alert alert-dismissible fade show d-none mt-2" role="alert"></div>
      </div>
      <div class="mt-2">Already Have an account? <a href="<?php echo $loc ?>/login" class="text-decoration-none text-primary">Login Now</a></div>
    </div>
    <!-- STEP 2: OTP Verification -->
    <div id="step2" class="card p-4 shadow mt-4 d-none"> <!-- -->
        <h6>Enter OTP</h6>
        <input type="text" id="otp" class="form-control mt-2" placeholder="Enter 6-digit OTP">
        <div class="badge bg-secondary mt-1 p-2">Please type the OTP sent to (<span id="phone-badge"></span>)</div>
        <!-- Resend OTP Section -->
        <div class="mt-2 text-center">
            <span>Didn’t get OTP yet?</span>
            <a href="#" id="resendOtp" class="text-muted ms-1 disabled">Resend OTP</a>
            <span id="timer" class="ms-2 text-danger fw-bold"></span>
        </div>

        <div class="d-flex justify-content-center mt-3">
            <button id="verifyOtpBtn" class="btn btn-success">Verify OTP <i class="bi bi-check2-circle"></i></button>
        </div>
        <div id="msg2" class="alert alert-dismissible fade show d-none mt-3" role="alert"></div>
    </div>

    <!-- STEP 3: Final Registration -->
    <div id="step3" class="card p-4 shadow mt-4 d-none"> <!-- -->
        <h6>Complete Registration</h6>

        <div class="form-floating mt-2">
          <select class="form-select" id="branch" aria-label="Select Branch">
            <option value="" selected>Select Branch</option>
            <?php
            $BranchQuery=$conn->query("select * from branch where BrStatus=1 order by BrId ASC");
            while ($BranchField = $BranchQuery->fetch_assoc()) { 
            ?>
            <option value="<?php echo $BranchField['BrId'] ?>"><?php echo $BranchField['BrName'] ?></option>
            <?php } ?>
          </select>
          <label for="branch" class="text-danger">Branch</label>
        </div>

        <div class="form-floating mt-2">
          <input type="text" maxlength="100" class="form-control" id="name" placeholder="Full Name">
          <label for="name" class="text-danger">Full Name</label>
        </div>

        <div class="form-floating mt-2">
          <select class="form-select" id="gender" aria-label="Select Gender">
            <option value="" selected>Select Gender</option>
            <option value="1">Male</option>
            <option value="2">Female</option>
          </select>
          <label for="gender" class="text-danger">Gender</label>
        </div>

        <div class="form-floating mt-2">
          <input type="text" maxlength="100" class="form-control" id="institute" placeholder="Institute Name">
          <label for="institute">Institute Name</label>
        </div>

        <div class="form-floating mt-2">
          <input type="email" maxlength="100" class="form-control" id="email" placeholder="Email">
          <label for="email">Email</label>
        </div>

        <div class="form-floating mt-2">
          <input type="text" maxlength="100" class="form-control" id="guardian" placeholder="Guardian Mobile">
          <label for="guardian">Guardian Mobile</label>
        </div>

        <div class="form-floating mt-2 position-relative">
        <input type="password" 
               minlength="6" 
               maxlength="12" 
               class="form-control" 
               id="password" 
               placeholder="Password" 
               required>
        <label for="password" class="text-danger">Password</label>
        
        <i id="togglePassword" 
           class="bi bi-eye-slash-fill position-absolute end-0 top-50 translate-middle-y me-3 text-muted" 
           style="cursor: pointer; z-index: 10;">
        </i>
      </div>

      <div id="password-strength" class="mt-1" style="font-size: 0.8rem; height: 1.5rem;">
        <span class="text-muted">Password must be 6 to 12 characters long.</span>
      </div>

        <button id="registerBtn" class="btn btn-warning mt-3 w-100">Submit <i class="bi bi-hand-index-thumb"></i></button>
        <div id="msg3" class="alert alert-dismissible fade show d-none mt-2" role="alert"></div>
      </div>
    </div>
  </div>
</div>

<script>
// ------------------------------
// Live Mobile Validation
// ------------------------------
function validateMobile() {
    let mobile = $("#mobile").val().replace(/\s+/g, ""); // remove spaces instantly
    $("#mobile").val(mobile); // update the field
    
    // Only numbers allowed
    if (!/^\d*$/.test(mobile)) {
        $("#mobile").addClass("is-invalid").removeClass("is-valid");
        return false;
    }

    // Must start with 01
    if ((mobile.length >= 2 && !mobile.startsWith("01")) || mobile.length >= 12) {
        $("#mobile").addClass("is-invalid").removeClass("is-valid");
        return false;
    }

    if (mobile.length >= 3 && mobile.length <= 10) {
        $("#mobile").removeClass("is-invalid").removeClass("is-valid");
        return false;
    }

    // Exact 11 digits
    if (mobile.length === 11) {
        $("#mobile").removeClass("is-invalid").addClass("is-valid");
        return true;
    }

    // Passed all conditions
    /*$("#mobile").removeClass("is-invalid").addClass("is-valid");
    return true;*/
}

// Live validate when typing
$("#mobile").on("input keyup change", function () {
    this.value = this.value.replace(/\D/g, "");
    validateMobile();
});

// Prevent invalid paste
$("#mobile,#otp").on("paste", function (e) {
    let pasteData = (e.originalEvent || e).clipboardData.getData("text");

    if (!/^\d+$/.test(pasteData)) {
        e.preventDefault();
    }
});

$("#otp,#guardian").on("input keyup change", function () {
    this.value = this.value.replace(/\D/g, "");
});


  function maskPhoneNumber(number) {
    number = $.trim(number);
    if (number.length < 6) return number;

    var first = number.substring(0, 3);
    var last  = number.substring(number.length - 3);

    return first + "*****" + last;
  }

  let countdownTime = 300; // 5 minutes = 300 seconds
  let timerInterval;

  function startTimer() {
    countdownTime = 300;
    $("#resendOtp").removeClass("enabled").addClass("disabled text-muted");
    runTimer();
  }

  function runTimer() {
      timerInterval = setInterval(() => {
          let minutes = Math.floor(countdownTime / 60);
          let seconds = countdownTime % 60;
          if (seconds < 10) seconds = "0" + seconds;

          $("#timer").text(`${minutes}:${seconds}`);

          countdownTime--;

          if (countdownTime < 0) {
              clearInterval(timerInterval);
              $("#timer").text("00:00");

              $("#resendOtp")
                  .removeClass("disabled text-muted")
                  .addClass("enabled text-primary");
          }
      }, 1000);
  }


  $("#resendOtp").click(function(e) {
    e.preventDefault();
    
    if ($(this).hasClass("disabled")) return;

    var mobile = $("#mobile").val();

    $.post("<?php echo $loc ?>/pages/send_otp.php", { mobile: mobile }, function(res) {
        if (res.status === "sent") {
            showAlertMessage("msg2","OTP Resent Successfully!", "success");
            startTimer(); // restart timer
        } else {
         showAlertMessage("msg1", res.message, "danger");
        }
    });
})

// Function to show alert without destroying the DOM element
// Updated function accepts 'elementId' as the first parameter
function showAlertMessage(elementId, message, type = "danger") {

    let msgBox = $("#" + elementId); // Target the specific ID

    msgBox.removeClass("d-none alert-danger alert-success fade-hide");
    msgBox.addClass("alert-" + type);

    // Add message + custom close button
    msgBox.html(`
        ${message}
        <button type="button" class="btn-close close-msg-btn"></button>
    `);

    // Auto hide logic
    setTimeout(() => {
        msgBox.addClass("fade-hide"); 
        setTimeout(() => {
            msgBox.addClass("d-none").removeClass("fade-hide");
        }, 1000); 
    }, 30000);
}

// Show/Hide Password Toggle Logic
$(document).on('click', '#togglePassword', function() {
    const passwordInput = $("#password");
    const type = passwordInput.attr('type') === 'password' ? 'text' : 'password';
    
    // 1. Swap the input type
    passwordInput.attr('type', type);
    
    // 2. Swap the icon class
    $(this).toggleClass('bi-eye-fill bi-eye-slash-fill');
});

// Password Length Indicator Logic
$("#password").on("input keyup change", function() {
    const password = $(this).val();
    const len = password.length;
    const indicator = $("#password-strength");

    indicator.removeClass("text-danger text-success text-muted");

    if (len === 0) {
        // Empty state
        indicator.html('<span class="text-muted">Password must be 6 to 12 characters long.</span>');
        $(this).removeClass("is-valid is-invalid");
    } else if (len < 6) {
        // Too short
        indicator.html(`<span class="text-danger">Length (${len}/6).</span>`);
        $(this).removeClass("is-invalid").removeClass("is-valid");
    } else if (len >= 6 && len <= 12) {
        // Correct length
        indicator.html(`<span class="text-success">Length OK (${len}/12).</span>`);
        $(this).addClass("is-valid").removeClass("is-invalid");
    } else {
        // Too long (Although HTML maxlength should prevent this, it's a safety check)
        indicator.html(`<span class="text-danger">Too long (max 12).</span>`);
        $(this).addClass("is-invalid").removeClass("is-valid");
    }
});

// Global close handler (works for msg1, msg2, and msg3)
$(document).on('click', '.close-msg-btn', function() {
    $(this).closest('.alert').addClass("d-none");
});

</script>
<script>

$("#sendOtpBtn").click(function() {
    
    // 1. Validate first (if invalid, stop here)
    if (!validateMobile()) {
        $("#mobile").addClass("is-invalid");
        return;
    }
   
    // 2. CAPTURE BUTTON & START LOADING
    // We save the button object to a variable '$btn'
    var $btn = $(this);
    // Save the original text (Next >) so we can restore it later
    var originalText = $btn.html(); 
    
    // Disable button and add spinner
    $btn.prop("disabled", true);
    $btn.html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Processing...');

    // Auto focus logic
    setTimeout(() => {
        $("#otp").focus();
    }, 250);

    let mobile = $("#mobile").val().trim();

    // 3. SEND REQUEST
    $.post("<?php echo $loc ?>/pages/send_otp.php", { mobile: mobile }, function(res) {
        // 4. STOP LOADING (Restore button state)
        // We do this immediately after response receives
        $btn.prop("disabled", false);
        $btn.html(originalText);

        if (res.status === "exists") {
            // Updated to use the new alert function we made
            showAlertMessage("msg1", res.message, "danger");
        } 
        else if (res.status === "sent") {
            showAlertMessage("msg1", res.message, "success");

            $("#step1").addClass("d-none");
            $("#step2").removeClass("d-none");
            
            startTimer();
            var masked = maskPhoneNumber(mobile);
            $("#phone-badge").text(masked);
        }else {
         showAlertMessage("msg1", res.message, "danger");
        }
    })
    .fail(function() {
        // Safety: If internet fails or php errors, re-enable button so user isn't stuck
        $btn.prop("disabled", false);
        $btn.html(originalText);
        showAlertMessage("msg1", "Something went wrong. Please try again.", "danger");
    });
});

$("#verifyOtpBtn").click(function() {
    
    // 1. CAPTURE BUTTON & START LOADING
    var $btn = $(this);
    var originalText = $btn.html(); 
    
    // Disable button and add spinner
    $btn.prop("disabled", true);
    $btn.html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Verifying...');

    // 2. GET VALUES (FIX: Ensure you are using the dynamic mobile input value)
    var mobile = $("#mobile").val(); 
    var otp = $("#otp").val();

    // 3. SEND REQUEST
    $.post("<?php echo $loc ?>/pages/verify_otp.php", { mobile: mobile, otp: otp }, function(res) {
        
        // 4. STOP LOADING (Always stop loading inside the success or failure callback)
        $btn.prop("disabled", false);
        $btn.html(originalText);

        //alert(res.status); // You can remove this alert once testing is complete
        
        if (res.status === "verified") {
            showAlertMessage("msg2", res.message, "success");
            $("#step2").addClass("d-none");
            $("#step3").removeClass("d-none");
            // Note: clearInterval(timerInterval) could be added here to stop the countdown
            clearInterval(timerInterval);
        } else {
            showAlertMessage("msg2", res.message, "danger");
        }
    })
    .fail(function() {
        // Handle connection failure
        $btn.prop("disabled", false);
        $btn.html(originalText);
        showAlertMessage("msg2", "Connection failed. Please check your network.", "danger");
    });
});

$("#registerBtn").click(function() {
    
    // 1. CAPTURE BUTTON & START LOADING
    var $btn = $(this);
    var originalText = $btn.html();
    
    $btn.prop("disabled", true);
    $btn.html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Submitting...');
    
    // Basic Client-Side Validation (Optional, but good practice)
    if (!$("#name").val() || $("#gender").val() === "" || !$("#password").val()) {
        showAlertMessage("msg3", "Please fill out all red label fields.", "danger");
        $btn.prop("disabled", false).html(originalText);
        return;
    }

    // ADD THE PASSWORD LENGTH CHECK HERE
    const password = $("#password").val();
    if (password.length < 6 || password.length > 12) {
        showAlertMessage("msg3", "Password must be between 6 and 12 characters.", "danger");
        $("#password").addClass("is-invalid");
        $btn.prop("disabled", false).html(originalText);
        return;
    }
    
    // 2. SEND REQUEST
    $.post("<?php echo $loc ?>/pages/register.php", {
        mobile: $("#mobile").val(),
        branch: $("#branch").val(),
        name: $("#name").val(),
        gender: $("#gender").val(),
        institute: $("#institute").val(),
        guardian_mobile: $("#guardian").val(),
        email: $("#email").val(),
        password: $("#password").val()
    }, function(res) {
        
        // 3. STOP LOADING
        $btn.prop("disabled", false);
        $btn.html(originalText);

        if (res.status === "success") {
            showAlertMessage("msg3", res.message, "success");
            //location.reload();
            window.location.replace("<?php echo $loc ?>/student");
        } else {
            showAlertMessage("msg3", res.message, "danger");
        }
    })
    .fail(function() {
        // Handle connection failure
        $btn.prop("disabled", false);
        $btn.html(originalText);
        showAlertMessage("msg3", "Connection failed. Could not reach server. Submit again.", "danger");
    });
});
</script>