<?php
header("Content-Type: application/json");
require "config-data.php";

$mobile = $_POST['mobile'];

// 1. Check if number already exists
$check = $conn->prepare("SELECT StId FROM student WHERE StMobile = ?");
$check->bind_param("s", $mobile);
$check->execute();
$check->store_result();

if ($check->num_rows > 0) {
    echo json_encode(["status" => "exists", "message" => "Mobile number already registered!"]);
    exit;
}

// 2. Generate OTP
$otp = rand(100000, 999999);

$expires = clone $date;
$expires->modify('+5 minutes');
$expires_at = $expires->format('Y-m-d H:i:s');

//$expires_at = date("Y-m-d H:i:s", time() + 300); // 5 minutes validity

// 3. Save OTP in DB
$stmt = $conn->prepare("INSERT INTO otp_request (OrMobile, OrOtp, OrExpiresAt) VALUES (?, ?, ?)");
$stmt->bind_param("sss", $mobile, $otp, $expires_at);
if ($stmt->execute()) {

$ApiQuery = $conn->query("SELECT * FROM apikey WHERE AkType = 2");
$ApiField = $ApiQuery->fetch_assoc();

$MobileNo=$mobile;
if($MobileNo!='' and strlen($MobileNo)>=11){
    $MobileNoISD='88'.$MobileNo;
    $msg = "Use OTP ".$otp." to complete the registration your Patronus account, valid for 5 minutes.";
    $apigateway->smsSending($ApiField['AkUser'],$ApiField['AkPass'],$ApiField['AkOpt01'],$ApiField['AkOpt02'],$ApiField['AkOpt03'],$msg,$MobileNoISD);
}

echo json_encode(["status" => "sent", "message" => "Verification code sent to your number."]);
} else {
echo json_encode(["status" => "error", "message" => "Failed to send OTP."]);
}
?>
