<?php
header("Content-Type: application/json");
require "config-data.php";

$branch = $_POST['branch'];
$mobile = $_POST['mobile'];
$name = $_POST['name'];
$gender = $_POST['gender'];
$institute = $_POST['institute'];
$guardian_mobile = $_POST['guardian_mobile'];
$email = $_POST['email'];
$password = password_hash($_POST['password'], PASSWORD_BCRYPT);

// Get last StCode
$result = $conn->query("SELECT StCode FROM student ORDER BY StId DESC LIMIT 1");
if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $lastId = $row['StCode'];
    $number = (int)substr($lastId, 2);
    $newNumber = $number + 1;
} else {
    // First record
    $newNumber = 1001;
}

$StCode = 'PE' . $newNumber;

$stmt = $conn->prepare("INSERT INTO student (BrId, StCode,StMobile, StName, StGender, StInstitute, StGuaMobile, StEmail, StPassword) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
$stmt->bind_param("isssissss", $branch, $StCode, $mobile, $name, $gender, $institute, $guardian_mobile, $email, $password);

if ($stmt->execute()) {
    $StId = $conn->insert_id;
    $_SESSION['loggedin'] = true;
    $_SESSION['stu'] = $StId;
    $_SESSION['name'] = $name;
    $_SESSION['mobile'] = $mobile;

    // --- 3-MONTH PERSISTENCE LOGIC START ---
    
    // 1. Generate a secure, unique token (e.g., 64 characters)
    $remember_token = bin2hex(random_bytes(32)); 
    
    // 2. Calculate the expiration time (90 days from now)
    $expiry_time = time() + (60 * 60 * 24 * 90); 

    // 3. Store the token in the database for the logged-in user
    $update_stmt = $conn->prepare("UPDATE student SET StRemToken = ? WHERE StId = ?");
    $update_stmt->bind_param("si", $remember_token, $StId);
    $update_stmt->execute();
    $update_stmt->close();

    // 4. Set the long-term persistence cookie (90 days)
    // The cookie stores the user ID and the token, separated by a pipe (|)
    $cookie_value = $StId . '|' . $remember_token;
    setcookie('remember_me', $cookie_value, $expiry_time, '/', '', false, true); // Secure and HttpOnly flags recommended

    // --- 3-MONTH PERSISTENCE LOGIC END ---

    echo json_encode(["status" => "success", "message" => "Registration Successful!"]);
} else {
    echo json_encode(["status" => "error", "message" => "Registration failed! Server error. Submit again."]);
}
?>
