<?php
header("Content-Type: application/json");
require "config-data.php";

$mobile = $_POST['mobile'] ?? '';
$otp = $_POST['otp'] ?? '';

if (empty($mobile) || empty($otp)) {
    echo json_encode(["status" => "error", "message" => "Mobile and OTP are required."]);
    exit;
}

$current_time = date('Y-m-d H:i:s');
$Status = 1; // Pending or active OTP status

// 1. Check if OTP is valid and not expired
$stmt = $conn->prepare("
    SELECT PrId 
    FROM password_reset 
    WHERE PrMobile = ? 
      AND PrOtp = ? 
      AND PrStatus = ? 
      AND PrExpiresAt > ? 
    ORDER BY PrId DESC 
    LIMIT 1
");

$stmt->bind_param("siss", $mobile, $otp, $Status, $current_time);
$stmt->execute();
$stmt->store_result();
if ($stmt->num_rows === 1) {

    $stmt->close();

    // Mark OTP as used (prevent reuse)
    $usedStatus = 2;
    $stmt = $conn->prepare("
        UPDATE password_reset 
        SET PrStatus = ? 
        WHERE PrMobile = ? AND PrOtp = ? 
        LIMIT 1
    ");
    $stmt->bind_param("iss", $usedStatus, $mobile, $otp);
    $stmt->execute();
    $stmt->close();

    echo json_encode(["status" => "success", "message" => "Verification successful!"]);

} else {
    echo json_encode(["status" => "error", "message" => "Invalid or expired verification code."]);
}

?>
