<?php
header("Content-Type: application/json");
require "config-data.php";

$mobile = $_POST['mobile'];

if (empty($mobile) || !preg_match('/^(01)\d{9}$/', $mobile)) {
    echo json_encode(["status" => "error", "message" => "Invalid mobile number format."]);
    exit;
}

// 1. Check if mobile number exists in the users table
$check = $conn->prepare("SELECT StId FROM student WHERE StMobile = ?");
$check->bind_param("s", $mobile);
$check->execute();
$check->store_result();

if ($check->num_rows == 0) {
    echo json_encode(["status" => "error", "message" => "Mobile number not registered."]);
    exit;
}
$check->close();

function generate_otp() {
    return str_pad(mt_rand(1, 999999), 6, '0', STR_PAD_LEFT);
}

// 2. Generate and store OTP
$otp = generate_otp();

$expires = clone $date;
$expires->modify('+5 minutes');
$expires_at = $expires->format('Y-m-d H:i:s');

//$expires_at = date('Y-m-d H:i:s', strtotime('+5 minutes')); // OTP valid for 5 minutes

// Delete old OTPs for this mobile number (Optional, but clean)
/*$stmt = $conn->prepare("DELETE FROM password_resets WHERE PrMobile = ?");
$stmt->bind_param("s", $mobile);
$stmt->execute();
$stmt->close();*/
$UpStatus=3; $Status=1;
$stmt = $conn->prepare("UPDATE password_reset SET PrStatus = ? WHERE PrMobile = ? AND PrStatus = ?");
$stmt->bind_param("isi", $UpStatus, $mobile, $Status);
$stmt->execute();
$stmt->close();

// Insert new OTP
$stmt = $conn->prepare("INSERT INTO password_reset (PrMobile, PrOtp, PrExpiresAt) VALUES (?, ?, ?)");
$stmt->bind_param("sss", $mobile, $otp, $expires_at);
if ($stmt->execute()) {

    // --- SIMULATION OF SMS SENDING ---
    // In a real application, you would call an SMS API here.
    $ApiQuery = $conn->query("SELECT * FROM apikey WHERE AkType = 2");
    $ApiField = $ApiQuery->fetch_assoc();

    $MobileNo=$mobile;
    if($MobileNo!='' and strlen($MobileNo)>=11){
        $MobileNoISD='88'.$MobileNo;
        $msg = "Use OTP ".$otp." to reset password your Patronus account, valid for 5 minutes.";
        $apigateway->smsSending($ApiField['AkUser'],$ApiField['AkPass'],$ApiField['AkOpt01'],$ApiField['AkOpt02'],$ApiField['AkOpt03'],$msg,$MobileNoISD);
    }

    echo json_encode(["status" => "success", "message" => "Sent"]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to generate OTP."]); /*$stmt->error*/
}

$stmt->close();

?>