<?php
header("Content-Type: application/json");
require "config-data.php";

$mobile = $_POST['mobile'] ?? '';
$password = $_POST['password'] ?? '';

if (empty($mobile) || empty($password)) {
    echo json_encode(["status" => "error", "message" => "Mobile and password are required."]);
    exit;
}

if (strlen($password) < 6 || strlen($password) > 12) {
    echo json_encode(["status" => "error", "message" => "Password must be 6-12 characters."]);
    exit;
}

// 1. Hash the new password securely
$hashed_password = password_hash($password, PASSWORD_DEFAULT);

// 2. Update the password in the users table
$stmt = $conn->prepare("UPDATE student SET StPassword = ? WHERE StMobile = ?");
$stmt->bind_param("ss", $hashed_password, $mobile);

if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "Password successfully reset!"]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to update password."]);
}

$stmt->close();

?>
