<div class="container my-5 poppins">
    <div class="row justify-content-center">
        <div class="col-md-5">
            <h3 class="text-center text-warning mb-4">Reset Password</h3>
            <div class="card shadow p-4">

                <div id="step1">
                    <h6>Enter Mobile Number</h6>
                    <div class="form-floating mb-3">
                        <input type="text" class="form-control" id="mobile" placeholder="01XXXXXXXXX" maxlength="11" required autocomplete="off">
                        <label for="mobile">Mobile Number</label>
                        <div class="invalid-feedback">Enter a valid 11-digit mobile number.</div>
                        <div class="valid-feedback">Looks good!</div>
                    </div>
                    <div id="alertMessage01" class="alert alert-dismissible fade show d-none mt-3" role="alert"></div>
                    <button id="sendOtpBtn" class="btn btn-primary w-100">Send OTP <i class="bi bi-caret-right"></i></button>
                </div>

                <div id="step2" class="d-none">
                    <h6>Enter OTP</h6>
                    <div class="badge bg-secondary mb-1 p-2 d-block text-center">
                        Please type the OTP sent to (<span id="maskedMobile"></span>)
                    </div>
                    <!-- <p class="text-muted small">Code sent to <strong id="maskedMobile"></strong></p> -->
                    <div class="form-floating mb-3">
                        <input type="text" class="form-control" id="otp" placeholder="Enter 6-digit Code" maxlength="6" required>
                        <label for="otp">OTP</label>
                    </div>
                    <button id="verifyOtpBtn" class="btn btn-success w-100">Verify OTP <i class="bi bi-check2-circle"></i></button>
                    <div class="text-center mt-2">
                        <small>Didn’t get OTP? <a href="#" id="resendOtp" class="text-muted ms-1 disabled">Resend</a><span id="timer" class="ms-2 text-danger fw-bold"></span></small>
                    </div>
                    <div id="alertMessage02" class="alert alert-dismissible fade show d-none mt-3" role="alert"></div>
                </div>

                <div id="step3" class="d-none">
                    <h6>Set New Password</h6>
                    <div class="form-floating position-relative mb-1">
                        <input type="password" class="form-control" id="newPassword" placeholder="New Password" minlength="6" maxlength="12" required>
                        <label for="newPassword">New Password</label>
                        <i id="togglePassword" class="bi bi-eye-slash-fill position-absolute end-0 top-50 translate-middle-y me-3 text-muted" style="cursor: pointer; z-index: 10;"></i>
                    </div>
                    <div id="password-strength" class="mb-1" style="font-size: 0.8rem;">
                      <span class="text-muted">Password must be 6 to 12 characters long.</span>
                    </div>
                    <button id="resetPasswordBtn" class="btn btn-warning w-100">Reset Password <i class="bi bi-shield-lock"></i></button>
                    <div id="alertMessage03" class="alert alert-dismissible fade show d-none mt-3" role="alert"></div>
                </div>
                
                <div id="successMessage" class="d-none text-center">
                    <i class="bi bi-check-circle-fill text-success" style="font-size: 3rem;"></i>
                    <h5 class="mt-3 text-success">Password Reset Successful!</h5>
                    <p>You can now <a href="<?php echo $loc ?>/login">login</a> with your new password.</p>
                </div>

            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    
    let currentMobile = '';
    
    // --- UTILITY FUNCTIONS ---
    
    // Generic alert display function
    function showAlert(elementId, message, type = "danger") {
        const $msg = $("#" + elementId); // Target the specific ID
        const messageHtml = `${message}<button type="button" class="btn-close manual-close-btn" aria-label="Close"></button>`;

        $msg.removeClass("d-none alert-success alert-danger show")
            .addClass(`alert-${type}`)
            .html(messageHtml);
            
        setTimeout(() => { $msg.addClass("show"); }, 10);
    }
    
    // Manual Close Handler
    $(document).on('click', '.manual-close-btn', function() {
        const $alert = $(this).closest('.alert');
        $alert.removeClass('show'); 
        setTimeout(function() { $alert.addClass('d-none'); }, 150); 
    });

    // Password Toggle
    $(document).on('click', '#togglePassword', function() {
        const passwordInput = $("#newPassword");
        const type = passwordInput.attr('type') === 'password' ? 'text' : 'password';
        passwordInput.attr('type', type);
        $(this).toggleClass('bi-eye-fill bi-eye-slash-fill');
    });

    // Password Length Indicator Logic
    $("#newPassword").on("input keyup change", function() {
        const password = $(this).val();
        const len = password.length;
        const indicator = $("#password-strength");

        indicator.removeClass("text-danger text-success text-muted");

        if (len === 0) {
            // Empty state
            indicator.html('<span class="text-muted">Password must be 6 to 12 characters long.</span>');
            $(this).removeClass("is-valid is-invalid");
        } else if (len < 6) {
            // Too short
            indicator.html(`<span class="text-danger">Length (${len}/6).</span>`);
            $(this).removeClass("is-invalid").removeClass("is-valid");
        } else if (len >= 6 && len <= 12) {
            // Correct length
            indicator.html(`<span class="text-success">Length OK (${len}/12).</span>`);
            $(this).addClass("is-valid").removeClass("is-invalid");
        } else {
            // Too long (Although HTML maxlength should prevent this, it's a safety check)
            indicator.html(`<span class="text-danger">Too long (max 12).</span>`);
            $(this).addClass("is-invalid").removeClass("is-valid");
        }
    });

    // Mobile Validation (Simplified)
    function validateMobile() {
        let mobile = $("#mobile").val().replace(/\s+/g, "");
        $("#mobile").val(mobile);
        
        if (!/^\d*$/.test(mobile)) {
            $("#mobile").addClass("is-invalid").removeClass("is-valid");
            return false;
        }

        if ((mobile.length >= 2 && !mobile.startsWith("01")) || mobile.length >= 12) {
            $("#mobile").addClass("is-invalid").removeClass("is-valid");
            return false;
        }

        if (mobile.length >= 3 && mobile.length <= 10) {
            $("#mobile").removeClass("is-invalid").removeClass("is-valid");
            return false;
        }

        if (mobile.length === 11) {
            $("#mobile").removeClass("is-invalid").addClass("is-valid");
            return true;
        }
    }

    // Live validate when typing
    $("#mobile").on("input keyup change", function () {
        this.value = this.value.replace(/\D/g, "");
        validateMobile();
    });
    
    let countdownTime = 300; // 5 minutes = 300 seconds
    let timerInterval;

      function startTimer() {
        countdownTime = 300;
        $("#resendOtp").removeClass("enabled").addClass("disabled text-muted");
        runTimer();
      }

      function runTimer() {
          timerInterval = setInterval(() => {
              let minutes = Math.floor(countdownTime / 60);
              let seconds = countdownTime % 60;
              if (seconds < 10) seconds = "0" + seconds;

              $("#timer").text(`${minutes}:${seconds}`);

              countdownTime--;

              if (countdownTime < 0) {
                  clearInterval(timerInterval);
                  $("#timer").text("00:00");

                  $("#resendOtp")
                      .removeClass("disabled text-muted")
                      .addClass("enabled text-primary");
              }
          }, 1000);
      }

    // --- STEP 1: SEND OTP ---
    $("#sendOtpBtn").click(function() {
        currentMobile = $("#mobile").val().trim();

        if (!validateMobile()) {
            $("#mobile").addClass("is-invalid");
            return;
        }

        const $btn = $(this);
        const originalText = $btn.html();
        $btn.prop("disabled", true).html('<span class="spinner-border spinner-border-sm"></span> Sending...');
        $("#alertMessage").addClass("d-none");

        $.post("<?php echo $loc ?>/pages/pfotp_send.php", { mobile: currentMobile }, function(res) {
            $btn.prop("disabled", false).html(originalText);
            
            if (res.status === "success") {
                showAlert("alertMessage01",res.message, "success");
                
                // Move to Step 2
                $("#step1").addClass("d-none");
                $("#step2").removeClass("d-none");
                $("#maskedMobile").text(currentMobile.replace(/^(\d{3})\d{5}(\d{3})$/, '$1*****$2'));
                $("#otp").focus();
                startTimer();
            } else {
                showAlert("alertMessage01",res.message);
            }
        }, "json").fail(function() {
            $btn.prop("disabled", false).html(originalText);
            showAlert("alertMessage01","Server error: Could not connect to send OTP.");
        });
    });

    // --- STEP 2: VERIFY OTP ---
    $("#verifyOtpBtn").click(function() {
        const otp = $("#otp").val().trim();
        if (otp.length !== 6 || isNaN(otp)) {
            showAlert("alertMessage02","Please enter the 6-digit verification code.");
            return;
        }

        const $btn = $(this);
        const originalText = $btn.html();
        $btn.prop("disabled", true).html('<span class="spinner-border spinner-border-sm"></span> Verifying...');
        $("#alertMessage").addClass("d-none");

        $.post("<?php echo $loc ?>/pages/pfotp_verify.php", { mobile: currentMobile, otp: otp }, function(res) {
            $btn.prop("disabled", false).html(originalText);
            //alert(res.status);
            if (res.status === "success") {
                showAlert("alertMessage02",res.message, "success");
                
                // Move to Step 3
                $("#step2").addClass("d-none");
                $("#step3").removeClass("d-none");
                $("#newPassword").focus();
            } else {
                showAlert("alertMessage02",res.message);
            }
        }, "json").fail(function() {
            $btn.prop("disabled", false).html(originalText);
            showAlert("alertMessage02","Server error: Could not verify OTP.");
        });
    });

    // Resend OTP functionality (sends back to step 1 logic)
    $("#resendOtp").click(function(e) {
        e.preventDefault();
        $("#sendOtpBtn").trigger("click");
        showAlert("alertMessage02","OTP Resent Successfully!", "success");
    });


    // --- STEP 3: RESET PASSWORD ---
    $("#resetPasswordBtn").click(function() {
        const newPassword = $("#newPassword").val();
        if (newPassword.length < 6 || newPassword.length > 12) {
            showAlert("alertMessage03","New password must be 6 to 12 characters long.");
            return;
        }
        const $btn = $(this);
        const originalText = $btn.html();
        $btn.prop("disabled", true).html('<span class="spinner-border spinner-border-sm"></span> Resetting...');
        $("#alertMessage").addClass("d-none");

        $.post("<?php echo $loc ?>/pages/pf_reset.php", { mobile: currentMobile, password: newPassword }, function(res) {
            $btn.prop("disabled", false).html(originalText);
            
            if (res.status === "success") {
                // Show final success message
                $("#step3").addClass("d-none");
                $("#successMessage").removeClass("d-none");
            } else {
                showAlert("alertMessage03",res.message);
            }
        }, "json").fail(function() {
            $btn.prop("disabled", false).html(originalText);
            showAlert("alertMessage03","Server error: Could not reset password.");
        });
    });
});
</script>
