<?php
header("Content-Type: application/json");
require "config-data.php";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    
    $mobile = trim($_POST['mobile'] ?? '');
    $password = $_POST['password'] ?? '';

    // Basic server-side validation
    if (empty($mobile) || empty($password)) {
        echo json_encode(["status" => "error", "message" => "Please fill in all fields."]);
        $conn->close();
        exit;
    }

    // Sanitize mobile number
    $mobile = $conn->real_escape_string($mobile);
    
    $stmt = $conn->prepare("SELECT StId, StName, StPassword FROM student WHERE StMobile = ?");
    $stmt->bind_param("s", $mobile);
    $stmt->execute();
    $stmt->store_result();
    if ($stmt->num_rows === 1) {
        
        $stmt->bind_result($StId, $StName, $StPassword);
        $stmt->fetch();
        
        $hashed_password = $StPassword;

        // --- 5. Verify Password ---
        // password_verify() safely compares the plain text password with the stored hash
        if (password_verify($password, $hashed_password)) {
            
            // Password is correct, create session variables
            $_SESSION['loggedin'] = true;
            $_SESSION['stu'] = $StId;
            $_SESSION['name'] = $StName;
            $_SESSION['mobile'] = $mobile;

            // --- 3-MONTH PERSISTENCE LOGIC START ---
    
            // 1. Generate a secure, unique token (e.g., 64 characters)
            $remember_token = bin2hex(random_bytes(32)); 
            
            // 2. Calculate the expiration time (90 days from now)
            $expiry_time = time() + (60 * 60 * 24 * 90); 

            // 3. Store the token in the database for the logged-in user
            $update_stmt = $conn->prepare("UPDATE student SET StRemToken = ? WHERE StId = ?");
            $update_stmt->bind_param("si", $remember_token, $StId);
            $update_stmt->execute();
            $update_stmt->close();

            // 4. Set the long-term persistence cookie (90 days)
            // The cookie stores the user ID and the token, separated by a pipe (|)
            $cookie_value = $StId . '|' . $remember_token;
            setcookie('remember_me', $cookie_value, $expiry_time, '/', '', false, true); // Secure and HttpOnly flags recommended

            // --- 3-MONTH PERSISTENCE LOGIC END ---

            // Return success response
            echo json_encode(["status" => "success", "message" => "Login successful. Redirecting..."]);
        } else {
            // Password is NOT correct
            echo json_encode(["status" => "error", "message" => "Invalid mobile number or password."]);
        }
    } else {
        // Mobile number does not exist
        echo json_encode(["status" => "error", "message" => "Invalid mobile number or password."]);
    }

    $stmt->close();
    $conn->close();
} else {
    // Handle non-POST requests
    echo json_encode(["status" => "error", "message" => "Invalid request method."]);
}
?>