<div class="container my-5 poppins">
    <div class="row justify-content-center">
        <div class="col-md-6 col-sm-8 align-self-center">
            <h3 class="text-center text-primary mb-4">Student Login 🔑</h3>
            <div class="card shadow p-4">
                <form id="loginForm">
                    <div class="form-floating mb-3">
                        <input type="text" class="form-control" id="mobile" name="mobile" 
                               placeholder="01XXXXXXXXX" maxlength="11" required autocomplete="off">
                        <label for="mobile">Mobile Number</label>
                        <div class="invalid-feedback" id="mobileFeedback">
                            Enter a valid 11-digit mobile number starting with '01'.
                        </div>
                    </div>

                    <div class="form-floating position-relative mb-3">
                        <input type="password" class="form-control" id="password" name="password" 
                               placeholder="Password" required autocomplete="off" minlength="6" maxlength="12">
                        <label for="password">Password</label>
                        
                        <i id="togglePassword" 
                           class="bi bi-eye-slash-fill position-absolute end-0 top-50 translate-middle-y me-3 text-muted" 
                           style="cursor: pointer; z-index: 10;">
                        </i>
                        <div class="invalid-feedback">Password is required (min 6 characters).</div>
                    </div>

                    <div id="loginMessage" class="alert alert-dismissible fade show d-none mt-3" role="alert"></div>

                    <button type="submit" id="loginBtn" class="btn btn-primary w-100">
                        Login <i class="bi bi-arrow-right-circle"></i>
                    </button>
                </form>
            </div>
            <div class="mt-2">Don't have an account? <a href="<?php echo $loc ?>/signin" class="text-decoration-none text-primary">Signin Now</a></div>
            <div class="mt-2">Forgot password? <a href="<?php echo $loc ?>/passforgot" class="text-decoration-none text-primary">Password reset</a></div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    
    // --- ALERT MESSAGE HELPER FUNCTION ---
    // This injects the message and the manual close button
    function displayLoginMessage(message, type = "danger") {
        const $msg = $("#loginMessage");
        
        // Structure the message with the manual close button
        const messageHtml = `
            ${message}
            <button type="button" class="btn-close manual-close-btn" aria-label="Close"></button>
        `;

        $msg.removeClass("d-none alert-success alert-danger show") // Clear previous state
            .addClass(`alert-${type}`)
            .html(messageHtml);
            
        // Timeout to ensure the content is injected before the animation starts
        setTimeout(() => {
            $msg.addClass("show"); // Trigger Bootstrap fade-in
        }, 10);
    }
    
    // --- MANUAL CLOSE HANDLER ---
    // This prevents Bootstrap from destroying the alert element, allowing reuse.
    $(document).on('click', '.manual-close-btn', function() {
        
        const $alert = $(this).closest('.alert');
        
        // 1. Remove 'show' class to trigger the fade-out animation
        $alert.removeClass('show'); 

        // 2. Wait for the fade (150ms) before making it fully invisible
        setTimeout(function() {
            $alert.addClass('d-none');
        }, 150); 
    });


    // --- Front-end Validation Functions ---
    
    function validateMobile() {
        let mobile = $("#mobile").val().replace(/\s+/g, "");
        $("#mobile").val(mobile);
        
        if (!/^\d*$/.test(mobile)) {
            $("#mobile").addClass("is-invalid").removeClass("is-valid");
            return false;
        }

        if ((mobile.length >= 2 && !mobile.startsWith("01")) || mobile.length >= 12) {
            $("#mobile").addClass("is-invalid").removeClass("is-valid");
            return false;
        }

        if (mobile.length >= 3 && mobile.length <= 10) {
            $("#mobile").removeClass("is-invalid").removeClass("is-valid");
            return false;
        }

        if (mobile.length === 11) {
            $("#mobile").removeClass("is-invalid").addClass("is-valid");
            return true;
        }
    }

    // Live validate when typing
    $("#mobile").on("input keyup change", function () {
        this.value = this.value.replace(/\D/g, "");
        validateMobile();
    });

    // Password Toggle Functionality
    $(document).on('click', '#togglePassword', function() {
        const passwordInput = $("#password");
        const type = passwordInput.attr('type') === 'password' ? 'text' : 'password';
        
        passwordInput.attr('type', type);
        $(this).toggleClass('bi-eye-fill bi-eye-slash-fill');
    });

    // --- AJAX Login Submission ---
    $("#loginForm").on("submit", function(e) {
        e.preventDefault();
        
        const $form = $(this);
        const $btn = $("#loginBtn");
        const originalText = $btn.html();
        let isValid = true;
        
        // 1. Final Client-side Validation Check
        const mobile = $("#mobile").val();
        const password = $("#password").val();
        
        if (!validateMobile(mobile)) {
            $("#mobile").addClass("is-invalid");
            isValid = false;
        } else {
            $("#mobile").removeClass("is-invalid");
        }

        if (password.length < 6 || password.length > 12) {
            $("#password").addClass("is-invalid");
            isValid = false;
        } else {
            $("#password").removeClass("is-invalid");
        }

        if (!isValid) {
            displayLoginMessage("Please correct the highlighted errors.", "danger");
            return;
        }
        
        // 2. Start Loading State
        $btn.prop("disabled", true).html('<span class="spinner-border spinner-border-sm" role="status"></span> Logging in...');
        
        // 3. AJAX Request
        $.ajax({
            type: "POST",
            url: "<?php echo $loc ?>/pages/login_process.php", // Make sure this path is correct
            data: $form.serialize(),
            dataType: "json",
            
            success: function(response) {
                // 4. Handle Success Response (from PHP)
                $btn.prop("disabled", false).html(originalText);
                
                if (response.status === "success") {
                    displayLoginMessage(response.message, "success");
                    
                    setTimeout(function() {
                        //window.location.replace("<?php echo $loc ?>/student");
                        const params = new URLSearchParams(window.location.search);
                        if (params.toString() === "") {
                        // No parameters passed
                        window.location.replace("<?php echo $loc ?>/student");
                        } else {
                        // Parameters exist
                        window.location.replace("<?php echo $loc ?>/checkout?" + params.toString());
                        }
                    }, 500);

                } else {
                    // Handle login failure (Invalid credentials, etc.)
                    displayLoginMessage(response.message, "danger");
                }
            },
            error: function(xhr, status, error) {
                // 5. Handle AJAX/Server Error
                $btn.prop("disabled", false).html(originalText);
                //console.error("AJAX Error:", status, error, xhr.responseText);
                displayLoginMessage("An unknown error occurred. Please try again.", "danger");
            }
        });
    });
});
</script>