<?php
$result = $conn->query("SELECT CaPic FROM carousel WHERE CaStatus = 1 ORDER BY CaOrder ASC");
// Convert data to array
$slides = [];
while ($row = $result->fetch_assoc()) {
    $slides[] = $row['CaPic'];
}
?>
<div id="carouselExampleIndicators" class="carousel slide" data-bs-ride="carousel" data-bs-interval="3000">

  <!-- Indicators -->
  <div class="carousel-indicators">
    <?php foreach ($slides as $index => $pic): ?>
      <button type="button"
        data-bs-target="#carouselExampleIndicators"
        data-bs-slide-to="<?= $index ?>"
        class="<?= $index === 0 ? 'active' : '' ?>">
      </button>
    <?php endforeach; ?>
  </div>

  <!-- Slides -->
  <div class="carousel-inner">
    <?php foreach ($slides as $index => $pic): ?>
      <div class="carousel-item <?= $index === 0 ? 'active' : '' ?>">
        <img src="<?php echo $loc ?>/media/carousel/<?= $pic ?>" class="d-block w-100">
      </div>
    <?php endforeach; ?>
  </div>

  <!-- Controls -->
  <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide="prev">
    <span class="carousel-control-prev-icon"></span>
  </button>

  <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide="next">
    <span class="carousel-control-next-icon"></span>
  </button>

</div>

<!-- Banner Section -->
<div class="container-fluid p-5 bg-primary text-white text-center">
  <h1 class="anek">পেট্রোনাস এডুকেশন এ স্বাগতম</h1>
  <p class="noto fs-5">এখানে মানসম্মত শিক্ষা ও আধুনিক জ্ঞান অর্জনের সুযোগ একসাথে পাওয়া যায়। আমাদের লক্ষ্য হলো শিক্ষার্থীদের দক্ষ, আত্মবিশ্বাসী ও ভবিষ্যৎ-প্রস্তুত করে গড়ে তোলা। অভিজ্ঞ শিক্ষক ও যুগোপযোগী পাঠ্যক্রমের মাধ্যমে এখানে একটি অনুকূল শেখার পরিবেশ নিশ্চিত করা হয়। পেট্রোনাস এডুকেশন প্রতিটি শিক্ষার্থীর সম্ভাবনাকে বিকশিত করতে আন্তরিকভাবে কাজ করে। আপনার উজ্জ্বল ভবিষ্যৎ গড়ার পথে পেট্রোনাস এডুকেশন সবসময় আপনার বিশ্বস্ত সঙ্গী।</p>
</div>
<?php
  // Fetch branches
  $branches = [];
  $branchQuery = $conn->query("SELECT BrId, BrName FROM branch WHERE BrStatus = 1 ORDER BY BrId ASC");
  while ($row = $branchQuery->fetch_assoc()) {
      $branches[] = $row;
  }

  // Fetch all courses (we will filter later)
  $courses = [];
  $courseQuery = $conn->query("SELECT * FROM course WHERE CoStatus = 1 ORDER BY CoId DESC");
  while ($row = $courseQuery->fetch_assoc()) {
      $courses[] = $row;
  }
  ?>
<!-- Tabs Section -->
<div class="container mt-5">
  <ul class="nav nav-pills justify-content-center gap-1" id="myTab">

    <li class="nav-item dropdown poppins">
      <a class="nav-link dropdown-toggle active" data-bs-toggle="dropdown">Courses</a>
      <ul class="dropdown-menu">
        <?php foreach ($branches as $index => $branch): ?>
        <li><a class="dropdown-item <?php echo $index === 0 ? 'active' : ''; ?>" data-bs-toggle="tab" href="#branch_<?= $branch['BrId'] ?>"><?= $branch['BrName'] ?></a></li>
        <?php endforeach; ?>
      </ul>
    </li>

    <li class="nav-item dropdown poppins">
      <a class="nav-link dropdown-toggle" data-bs-toggle="dropdown">Study Abroad</a>
      <ul class="dropdown-menu">
        <li><a class="dropdown-item" data-bs-toggle="tab" href="#usa">USA</a></li>
        <li><a class="dropdown-item" data-bs-toggle="tab" href="#europe">Europe</a></li>
        <li><a class="dropdown-item" data-bs-toggle="tab" href="#australia">Australia</a></li>
      </ul>
    </li>

  </ul>

  <!-- Tab Content -->
  <div class="tab-content mt-4">

    <?php foreach ($branches as $index => $branch): ?>
        <div class="tab-pane fade <?php echo $index === 0 ? 'show active' : ''; ?>"
             id="branch_<?= $branch['BrId'] ?>">

            <h3 class="text-center"><?= $branch['BrName'] ?> – Courses</h3>

            <div class="row row-cols-1 row-cols-md-3 g-4 justify-content-center">

                <?php
                $hasCourses = false;

                foreach ($courses as $course):
                    // Convert "1,2,3" into array → ["1","2","3"]
                    $branchIds = explode(",", $course['BrId']);

                    // Check if current branch is in this course
                    if (in_array($branch['BrId'], $branchIds)):
                        $hasCourses = true;
                ?>
                    <div class="col">
                        <div class="card shadow-lg h-100">
                            <img src="<?php echo $loc ?>/media/course/card/<?= $course['CoCardPic'] ?>" class="card-img-top">
                            <div class="card-body card-body-gradient d-flex flex-column">
                                <h5 class="card-title"><?= $course['CoTitle'] ?></h5>

                                <div class="d-flex justify-content-between align-items-center mt-auto">
                                    <div>
                                        <div>Price: <?= $course['CoPrice'] ?> Tk</div>
                                    </div>

                                    <a href="<?php echo $loc ?>/course?b=<?= $branch['BrId'] ?>&c=<?= $course['CoId'] ?>"
                                       class="btn btn-outline-primary">
                                       Details
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>

                <?php
                    endif;
                endforeach;

                if (!$hasCourses):
                ?>
                    <p class="text-muted text-center">No courses available for this branch.</p>
                <?php endif; ?>

            </div>

        </div>
    <?php endforeach; ?>

    </div>

    <div class="tab-pane fade" id="usa">
      <h3>USA Study Abroad</h3>
      <p>USA study abroad information.</p>
    </div>

    <div class="tab-pane fade" id="europe">
      <h3>Europe Study Abroad</h3>
      <p>Europe study abroad information.</p>
    </div>

    <div class="tab-pane fade" id="australia">
      <h3>Australia Study Abroad</h3>
      <p>Australia study abroad information.</p>
    </div>

  </div>
</div>