<?php
require "config-data.php";

$UserId=$_SESSION['stu'];

$BrId=htmlentities($_POST['BrId'], ENT_QUOTES);
$CoId=htmlentities($_POST['CoId'], ENT_QUOTES);
$CoursePrice=htmlentities($_POST['CoursePrice'], ENT_QUOTES);
$DiscPrice=htmlentities($_POST['DiscPrice'], ENT_QUOTES);

$Price = ($DiscPrice !== "") ? $DiscPrice : $CoursePrice;

$insert = "INSERT INTO course_enroll (StId,BrId,CoId,CeDate,CePrice,CeDiscPrice) VALUES (?, ?, ?, ?, ?, ?)";
$stmt = $conn->prepare($insert);
$stmt->bind_param("iiisii", $UserId, $BrId, $CoId, $Today, $CoursePrice, $DiscPrice);
$stmt->execute();

$lastId = $conn->insert_id;

// Example invoice format: INV-1225-000123
$invoice = "ERC-" . date("my") . "-" . str_pad($lastId, 6, "0", STR_PAD_LEFT);

$update = "UPDATE course_enroll SET CeInvoice=? WHERE CeId=?";
$stmt = $conn->prepare($update);
$stmt->bind_param("si", $invoice, $lastId);
$stmt->execute();

include_once '../bkash/token.php';
    
//$callbackURL='https://www.dpblbd.com/pages/bkash-callback.php';
$callbackURL='https://www.bdinfobiz.com/pe/pages/bkash-callback.php';

$auth = $_SESSION['token'];

$requestbody = array(
'mode' => '0011',
'amount' => $Price,
'currency' => 'BDT',
'intent' => 'sale',
'payerReference' => $UserId,
'merchantInvoiceNumber' => $invoice,
'callbackURL' => $callbackURL
);
$url = curl_init($credentials_arr['base_url'].'/v1.2.0-beta/tokenized/checkout/create');   
$requestbodyJson = json_encode($requestbody);

$header = array(
'Content-Type:application/json',
'Authorization:' . $auth,
'X-APP-Key:'. $credentials_arr['app_key']
);

curl_setopt($url, CURLOPT_HTTPHEADER, $header);
curl_setopt($url, CURLOPT_CUSTOMREQUEST, "POST");
curl_setopt($url, CURLOPT_RETURNTRANSFER, true);
curl_setopt($url, CURLOPT_POSTFIELDS, $requestbodyJson);
curl_setopt($url, CURLOPT_FOLLOWLOCATION, 1);
curl_setopt($url, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
$resultdata = curl_exec($url);
curl_close($url);
//echo $resultdata;

$obj = json_decode($resultdata, true);

//print_r($obj);

//$paymentID = $obj['paymentID'];

exit(header("Location: " . $obj['bkashURL']));

?>
