<?php
	class insert
	{
		
	function __construct()
	{
		
	}

	public function nullify_blank($value) {
    if (is_string($value)) {
        $value = trim($value);
	    }
	    return ($value === '') ? NULL : $value;
	}

	public function get_type_char($value): string {
	    if (is_null($value)) {
	        return 's'; // NULL is often bound as a string type for safety
	    } elseif (is_int($value)) {
	        return 'i'; // integer
	    } elseif (is_float($value)) {
	        return 'd'; // double/float
	    }
	    return 's'; // default to string
	}

	function updateData(mysqli $conn, string $table, array $data, array $whereData): array
	{
	    if (empty($data) || empty($whereData)) {
	        return ["status" => "error", "message" => "Update data or WHERE condition cannot be empty.", "affected_rows" => 0];
	    }
	    
	    $set_clauses = [];
	    $where_clauses = [];
	    $types = '';
	    $values = [];

	    // --- 1. Prepare Data and Collect Values/Types for SET clause ---
	    foreach ($data as $column => $value) {
	        $set_value = $this->nullify_blank($value); // Convert blank strings to NULL
	        $set_clauses[] = "`{$column}` = ?";
	        
	        $types .= $this->get_type_char($set_value);
	        $values[] = $set_value;
	    }

	    // --- 2. Prepare Data and Collect Values/Types for WHERE clause ---
	    foreach ($whereData as $column => $value) {
	        // WHERE data is also nullified to match any potential NULL keys correctly (optional)
	        $where_value = $this->nullify_blank($value); 
	        $where_clauses[] = "`{$column}` = ?"; 
	        
	        $types .= $this->get_type_char($where_value);
	        $values[] = $where_value;
	    }

	    $setClause = implode(", ", $set_clauses);
	    $whereClause = implode(" AND ", $where_clauses);

	    // --- 3. Build SQL and Prepare Statement ---
	    $sql = "UPDATE `{$table}` SET {$setClause} WHERE {$whereClause}";

	    $stmt = $conn->prepare($sql);
	    if (!$stmt) {
	        return ["status" => "error", "message" => "SQL Prepare failed: " . $conn->error, "affected_rows" => 0];
	    }

	    // --- 4. Bind Parameters and Execute ---
	    // The ...$values spread operator works efficiently in PHP 5.6+
	    $stmt->bind_param($types, ...$values);

	    if (!$stmt->execute()) {
	        $error_message = $stmt->error;
	        $stmt->close();
	        return ["status" => "error", "message" => "Execution failed: " . $error_message, "affected_rows" => 0];
	    }

	    $affected_rows = $stmt->affected_rows;
	    $stmt->close();
	    
	    // --- 5. Return Status and Feedback ---
	    $status = ($affected_rows > 0) ? "success" : "warning";
	    $message = ($affected_rows > 0) 
	        ? "Record updated successfully. Total affected: {$affected_rows}." 
	        : "No rows updated. Record not found or data was identical.";

	    return ["status" => $status, "message" => $message, "affected_rows" => $affected_rows];
	}
		
	public function array_breaker($array)
	{
		$value="";
		foreach($array as $sql)
		{
			
			$value=$value."'$sql',";
		}
		$val=substr($value,0,-1);
		return $val;
	}
	
	function normal_insert($table,$array2)
	{
		global $conn;
		$k=$this->array_breaker($array2);
		//$query="insert into $table values('".$k."')";
		$query="insert into $table values($k)";
		$result=mysqli_query($conn,$query);
		return $result;
	}
	
	function DynamicUpdate($table_name,$update_field,$identification)
	{
    global $conn;
	$dyn="update $table_name set
	$update_field
	where 
	$identification
	";
	$result=mysqli_query($conn,$dyn);
    return $result;
	}
	
	function DynamicDelete($table,$identification)
	{
	global $conn;
	$dydl="delete from $table 
	where 
	$identification
	";
	$result=mysqli_query($conn,$dydl);
	return $result;
	
	}
	
	}
?>

