<?php session_start(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <title>mamunsir:login</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <link rel="shortcut icon" type="image/x-icon" href="../images/icons/favicon.ico">
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css">
  <script src="https://code.jquery.com/jquery-3.2.1.slim.min.js"></script>
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js"></script>
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

  <style type="text/css">
   :root {
    --input-padding-x: 1.5rem;
    --input-padding-y: .75rem;
    }

    body {
    background: #9CECFB;
    /* fallback for old browsers */
    background: -webkit-linear-gradient(to right, #0052D4, #65C7F7, #9CECFB);
    /* Chrome 10-25, Safari 5.1-6 */
    background: linear-gradient(to right, #0052D4, #65C7F7, #9CECFB);
    /* W3C, IE 10+/ Edge, Firefox 16+, Chrome 26+, Opera 12+, Safari 7+ */
    }

    .card-signin {
    border: 0;
    border-radius: 1rem;
    box-shadow: 0 0.5rem 1rem 0 rgba(0, 0, 0, 0.1);
    }

    .card-signin .card-title {
    margin-bottom: 2rem;
    font-weight: 700;
    font-size: 1.5rem;
    }

    .card-signin .card-body {
    padding: 2rem;
    }

    .form-signin {
    width: 100%;
    }

    .form-signin .btn {
    font-size: 80%;
    border-radius: 5rem;
    letter-spacing: .1rem;
    font-weight: bold;
    padding: 1rem;
    transition: all 0.2s;
    }

    .form-label-group {
    position: relative;
    margin-bottom: 1rem;
    }

    .form-label-group input {
    border-radius: 2rem;
    }

    .form-label-group>input,
    .form-label-group>label {
    padding: var(--input-padding-y) var(--input-padding-x);
    }

    .form-label-group>label {
    position: absolute;
    top: 0;
    left: 0;
    display: block;
    width: 100%;
    margin-bottom: 0;
    /* Override default `<label>` margin */
    line-height: 1.5;
    color: #495057;
    border: 1px solid transparent;
    border-radius: .25rem;
    transition: all .1s ease-in-out;
    }

    .form-label-group input::-webkit-input-placeholder {
    color: transparent;
    }

    .form-label-group input:-ms-input-placeholder {
    color: transparent;
    }

    .form-label-group input::-ms-input-placeholder {
    color: transparent;
    }

    .form-label-group input::-moz-placeholder {
    color: transparent;
    }

    .form-label-group input::placeholder {
    color: transparent;
    }

    .form-label-group input:not(:placeholder-shown) {
    padding-top: calc(var(--input-padding-y) + var(--input-padding-y) * (2 / 3));
    padding-bottom: calc(var(--input-padding-y) / 3);
    }

    .form-label-group input:not(:placeholder-shown)~label {
    padding-top: calc(var(--input-padding-y) / 3);
    padding-bottom: calc(var(--input-padding-y) / 3);
    font-size: 12px;
    color: #777;
    }

    .btn-google {
    color: white;
    background-color: #ea4335;
    }

    .btn-facebook {
    color: white;
    background-color: #3b5998;
    }
    .forgot-pass{
        cursor: pointer;
    }
    .forgot-pass:hover{
        color: green !important;
    }
    .forgot-active{
        color: green !important;
    }
    .fpa-area{
        display: none;
    }

   </style>
<script>
$(document).ready(function(){
  $(".forgot-pass").click(function(){
    $(this).toggleClass("forgot-active");
    $(".fpa-area").toggle('slow');
    $("input[name=Username]").focus();
  });

  // this is the id of the form
  $("#form-forgot").submit(function(e) {

    e.preventDefault(); // avoid to execute the actual submit of the form.
    $(".saving").html('<i class="fa fa-refresh fa-spin"></i>');
    var form = $(this);
    var url = form.attr('action');
    
    $.ajax({
           type: "POST",
           url: url,
           data: form.serialize(), // serializes the form's elements.
           success: function(data)
           {
               //alert(data); // show response from the php script.
               if(data==1) {
                 $(".emailstatus").html("<span class='text-danger'>This input information did not exist.</span>"); 
               } else if(data==2) {
                 $(".emailstatus").html("<span class='text-danger'>Email no. did not exist for this input information.</span>");
               } else {
                 $(".emailstatus").html("<span class='text-success'>New password sent to your email no.</span>");
               }
               $(".saving").html('<i class="fa fa-user"></i>');

               setTimeout(function(){
                    $(".emailstatus span").fadeOut('slow')
                }, 5000)
           }
         });
  });

});
</script>
</head>
<body>
   <div class="container">
    <div class="row">
      <div class="col-sm-9 col-md-7 col-lg-5 mx-auto my-5">
       <div class="text-center"><img src="../images/icons/id-logo.png" class="img-fluid"></div>
        <div class="card card-signin">
          <div class="card-body">
            <h5 class="card-title text-center">Sign In</h5>


            <?php //////
              
              if(isset($_SESSION['LoginError'])){
                $mess=$_SESSION['LoginError'];
                if($mess==1)
                {   echo "<p class='text-danger text-center'><strong> User Id & password did not match! </strong></p>";}
                else if($mess==2)
                {   echo "<p class='text-danger text-center'><strong> Login blocked for 1 hours after 5 failed login attempts </strong></p>";   }
                else
                {   echo "";  }
                unset($_SESSION['LoginError']);
            }
            ?>


            <form class="form-signin"  action="checklogin.php" method="post">
              <div class="form-label-group">
                <input type="text" id="UserId" name="ChikiChiki" class="form-control" placeholder="User Id" required autofocus>
                <label for="UserId">User Id</label>
              </div>

              <div class="form-label-group">
                <input type="password" name="Bumbum" id="inputPassword" class="form-control" placeholder="Password" required>
                <label for="inputPassword">Password</label>
              </div>

              <div class="custom-control custom-checkbox mb-3">
                <input type="checkbox" class="custom-control-input" id="customCheck1">
                <label class="custom-control-label" for="customCheck1">Remember password</label>
              </div>
              <button class="btn btn-lg btn-primary btn-block text-uppercase" type="submit">Sign in</button>
            </form>
            <p class="text-center mt-3 text-primary forgot-pass"><strong>Forgot password</strong></p>
            <div class="fpa-area">
                 <div class="emailstatus text-center"></div>
                 <form id="form-forgot" class="form-signin" action="forgot-password.php" method="post">
                  <div class="form-label-group">
                    <input type="text" id="FpUserId" name="Username" class="form-control" placeholder="User ID or Email or Mobile No." required>
                    <label for="FpUserId">User ID or Email or Mobile No.</label>
                  </div>
                  <button class="btn btn-lg btn-primary btn-block text-uppercase" type="submit"><span class="saving"><i class="fa fa-user" aria-hidden="true"></i></span> Send</button>
                </form>
            </div>

          </div>
        </div>
      </div>
    </div>
  </div>
</body>
</html>
