<link href="assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css"/>
 <!-- Modal HTML -->
  <div id="modality"></div>
  <!-- Modal HTML -->
<!--begin::Content-->
<div id="kt_app_content" class="app-content flex-column-fluid">
	
	<!--begin::Content container-->
	<div id="kt_app_content_container" class="app-container container-xxl">
		<!--begin::Card-->
		<div class="card">
			<!--begin::Heading-->
			<div class="text-center mt-4">
				<!--begin::Title-->
				<h1 class="mt-2">Stock Product</h1>
				<!--end::Title-->
			</div>
			<!--end::Heading-->
			<!--begin::Card header-->
			<div class="card-header border-0 pt-2">
				<!--begin::Card title-->
				<div class="card-title">
					<!--begin::Search-->
					<div class="d-flex align-items-center position-relative my-1">
						<i class="ki-duotone ki-magnifier fs-3 position-absolute ms-5">
							<span class="path1"></span>
							<span class="path2"></span>
						</i>
						<input type="text" data-kt-filter="search" class="form-control form-control-solid w-250px ps-14" placeholder="Search Report" />
					</div>
					<!--end::Search-->
					<!--begin::Export buttons-->
					<div id="kt_datatable_product_1_export" class="d-none"></div>
					<!--end::Export buttons-->
				</div>
				<!--begin::Card title-->
				<!--begin::Card toolbar-->
				<div class="card-toolbar">
					<!--begin::Export dropdown-->
					<button type="button" class="btn btn-light-primary" data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">
						<i class="ki-duotone ki-exit-down fs-2"><span class="path1"></span><span class="path2"></span></i>
						Export Report
					</button>
					<!--begin::Menu-->
					<div id="kt_datatable_product_export_menu" class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-600 menu-state-bg-light-primary fw-semibold fs-7 w-200px py-4" data-kt-menu="true">
						<!--begin::Menu item-->
						<div class="menu-item px-3">
							<a href="#" class="menu-link px-3" data-kt-export="copy">
							Copy to clipboard
							</a>
						</div>
						<!--end::Menu item-->
						<!--begin::Menu item-->
						<div class="menu-item px-3">
							<a href="#" class="menu-link px-3" data-kt-export="excel">
							Export as Excel
							</a>
						</div>
						<!--end::Menu item-->
						<!--begin::Menu item-->
						<div class="menu-item px-3">
							<a href="#" class="menu-link px-3" data-kt-export="csv">
							Export as CSV
							</a>
						</div>
						<!--end::Menu item-->
						<!--begin::Menu item-->
						<div class="menu-item px-3">
							<a href="#" class="menu-link px-3" data-kt-export="pdf">
							Export as PDF
							</a>
						</div>
						<!--end::Menu item-->
					</div>
					<!--end::Menu-->
					<!--end::Export dropdown-->

					<!--begin::Hide default export buttons-->
					<div id="kt_datatable_product_buttons" class="d-none"></div>
					<!--end::Hide default export buttons-->
				</div>
				<!--end::Card toolbar-->
			</div>
			<!--end::Card header-->
			<!--begin::Card body-->
			<div class="card-body pt-0">
				<!--begin::Table-->
				<table class="table table-striped table-row-bordered align-middle gy-5 gs-7 border rounded" id="kt_datatable_product">
					<thead>
						<!--begin::Table row-->
						<tr class="text-start text-gray-500 fw-bold fs-7 text-uppercase">
							<th class="text-center">#</th>
							<th class="text-start min-w-100px">Code</th>
							<th class="min-w-100px">Name</th>
							<th class="min-w-100px">Brand</th>
							<th class="min-w-100px">Vendor</th>
							<th class="text-end min-w-70px">Cost</th>
							<th class="text-end min-w-70px">Price</th>
							<th class="text-end min-w-100px">Alert Qty</th>
							<th class="text-end min-w-100px">Stock Qty</th>
						</tr>
						<!--end::Table row-->
					</thead>
					<tbody class="fw-semibold text-gray-600">
					<?php
				    $s=0;   
				    $result01=mysqli_query($con, "select *,SUM(s.PrsQty) AS TotalStockQuantity from mws_product as a left join mws_category as b on a.CaId=b.CaId left join mws_brands as c on a.BrId=c.BrId inner join mws_product_stock s ON a.PrId = s.PrId where a.PrStatus=1 GROUP BY a.PrId HAVING SUM(s.PrsQty) > 0 ORDER BY TotalStockQuantity DESC;");
				    while($field01=mysqli_fetch_array($result01))
				    { $s++;
				    ?>
						<tr class="text-center">
							<td><?php echo $s ?></td>
							<td class="text-start pe-0">
								<span data-url="pages/product-details.php?p=<?php echo $field01['PrId'] ?>" class="text-gray-900 text-hover-primary view-modal"><?php echo $field01['PrCode'];?></span>
							</td>
							<td class="text-start py-2 pe-0">
								<div class="d-flex align-items-center">
									<!--begin::Thumbnail-->
									<?php if(!is_null($field01['PrImage'])){ ?>
									<div class="symbol symbol-40px me-3">
										<span class="symbol-label" style="background-image:url(../media/product/<?php echo $field01['PrImage'] ?>);"></span>
									</div>
								    <?php } ?>
									<!--end::Thumbnail-->
									<div data-kt-product-filter="product_name">
										<?php echo $field01['PrName'] ?>
									</div>
								</div>
							</td>
							<!-- <td class="text-start pe-0" data-kt-ecommerce-product-filter="product_name"><?php echo $field01['PrName'] ?></td> -->
							<td class="text-start pe-0"><?php echo $field01['BrName'] ?></td>
							<td class="text-start pe-0"><?php echo $field01['PrVenName'] ?></td>
							<td class="text-end pe-0"><?php echo $field01['PrCost']+0 ?></td>
							<td class="text-end pe-0"><?php echo $field01['PrPrice']+0 ?></td>
							<td class="text-end pe-0"><?php echo $field01['PrAlertQty'] ?></td>
							<td class="text-center pe-2"><?php echo $field01['TotalStockQuantity'] ?></td>
						</tr>
					<?php } ?>
					</tbody>
				</table>
				<!--end::Table-->
			</div>
			<!--end::Card body-->
		</div>
		<!--end::Card-->
	</div>
	<!--end::Content container-->
</div>
<!--end::Content-->
<script src="assets/js/scripts.bundle-modal.js"></script>
<script src="assets/plugins/custom/datatables/datatables.bundle.js"></script>
<script>
$('.view-modal').on('click', function () {
    $('#modality').load($(this).data("url"), function () {
      $('.kt_modal_add').modal('show');
      initModalScripts();
    });
 });
$(document).on('hidden.bs.modal', '.kt_modal_add', function () {
    initModalScripts();
});

"use strict";

// Class definition
var KTDatatablesProduct = function () {
    // Shared variables
    var table;
    var datatable;

    // Private functions
    var initDatatable = function () {
        // Set date data order
        const tableRows = table.querySelectorAll('tbody tr');

        // Init datatable --- more info on datatables: https://datatables.net/manual/
        datatable = $(table).DataTable({
        	"lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
            /*"info": false,*//*Showing records*/
            'pageLength': 25,
            'order': [],
            responsive: true,
            rowReorder: true
            /*dom: 'Brtip',
            buttons: [
			  {
			    extend: 'colvis',
			    text: 'Columns',
			    className: 'btn btn-light-warning btn-sm'
			  }
			]*/
        });
    }

    // Hook export buttons
    var exportButtons = () => {
        const documentTitle = 'Product List';
        var buttons = new $.fn.dataTable.Buttons(table, {
            buttons: [
                {
                    extend: 'copyHtml5',
                    title: documentTitle
                },
                {
                    extend: 'excelHtml5',
                    title: documentTitle
                },
                {
                    extend: 'csvHtml5',
                    title: documentTitle
                },
                {
                    extend: 'pdfHtml5',
                    title: documentTitle
                }
            ]
        }).container().appendTo($('#kt_datatable_product_buttons'));

        // Hook dropdown menu click event to datatable export buttons
        const exportButtons = document.querySelectorAll('#kt_datatable_product_export_menu [data-kt-export]');
        exportButtons.forEach(exportButton => {
            exportButton.addEventListener('click', e => {
                e.preventDefault();

                // Get clicked export value
                const exportValue = e.target.getAttribute('data-kt-export');
                const target = document.querySelector('.dt-buttons .buttons-' + exportValue);

                // Trigger click event on hidden datatable export buttons
                target.click();
            });
        });
    }

    // Search Datatable --- official docs reference: https://datatables.net/reference/api/search()
    var handleSearchDatatable = () => {
        const filterSearch = document.querySelector('[data-kt-filter="search"]');
        filterSearch.addEventListener('keyup', function (e) {
            datatable.search(e.target.value).draw();
        });
    }

    // Public methods
    return {
        init: function () {
            table = document.querySelector('#kt_datatable_product');

            if ( !table ) {
                return;
            }

            initDatatable();
            exportButtons();
            handleSearchDatatable();
        }
    };
}();

// On document ready
KTUtil.onDOMContentLoaded(function () {
    KTDatatablesProduct.init();
});

</script>
