<?php
	include_once 'config-data.php';
	header("Content-Type: application/json");

	if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Process form

    $result = $conn->query("SHOW TABLE STATUS LIKE 'carousel'");
    $field01 = $result->fetch_assoc();
    // This is the next ID the database will assign
    $CaId = $field01['Auto_increment'];
    
	// Check if a file was uploaded
	if (isset($_FILES['CaImage']) && $_FILES['CaImage']['error'] === UPLOAD_ERR_OK) {

	    $uploadDir = '../../media/carousel/';
	    $maxWidth = 1920; // Thumbnail width
	    //$allowedTypes = ['image/jpeg', 'image/png', 'image/gif'];

	    $file = $_FILES['CaImage'];
	    $fileType = mime_content_type($file['tmp_name']);
	    
	    // Validate file type
	    /*if (!in_array($fileType, $allowedTypes)) {
	        die('Error: Only JPEG, PNG, and GIF images are allowed.');
	    }*/

	    // Get image info
	    list($width, $height) = getimagesize($file['tmp_name']);
	    
	    // Brlculate thumbnail dimensions
	    $ratio = $maxWidth / $width;
	    $newHeight = $height * $ratio;
	    
	    // Create thumbnail
	    $thumb = imagecreatetruecolor($maxWidth, $newHeight);
	    
	    // Load source image based on type
	    switch ($fileType) {
	        case 'image/jpeg':
	            $source = imagecreatefromjpeg($file['tmp_name']);
	            break;
	        case 'image/png':
	            $source = imagecreatefrompng($file['tmp_name']);
	            break;
	        case 'image/gif':
	            $source = imagecreatefromgif($file['tmp_name']);
	            break;
	        default:
	            die(json_encode(["state" => "error1", "message" => "Unsupported image type!"]));
	    }

	    // Preserve transparency for PNG and GIF
	    if ($fileType === 'image/png' || $fileType === 'image/gif') {
	        imagecolortransparent($thumb, imagecolorallocatealpha($thumb, 0, 0, 0, 127));
	        imagealphablending($thumb, false);
	        imagesavealpha($thumb, true);
	    }

	    // Resize image
	    imagecopyresampled($thumb, $source, 0, 0, 0, 0, $maxWidth, $newHeight, $width, $height);

	    // Generate unique filename for thumbnail
	    $CraImage = $CaId . '.' . pathinfo($file['name'], PATHINFO_EXTENSION);
	    $thumbPath = $uploadDir . $CraImage;

	    // Save thumbnail based on type
	    switch ($fileType) {
	        case 'image/jpeg':
	            imagejpeg($thumb, $thumbPath, 90);
	            break;
	        case 'image/png':
	            imagepng($thumb, $thumbPath, 9);
	            break;
	        case 'image/gif':
	            imagegif($thumb, $thumbPath);
	            break;
	    }

	    // Clean up
	    imagedestroy($source);
	    imagedestroy($thumb);

	    //echo "Thumbnail created and uploaded successfully: $thumbPath";
	} else {
	    //echo "Error: No valid image file uploaded.";
	    $CraImage="";
	}
        
		$stmt = $conn->prepare("INSERT INTO carousel (CaPic, CaOrder, CaUsId) VALUES (?, ?, ?)");
		$stmt->bind_param("sii", $CraImage,$CaId,$UserId);
		$stmt->execute();

		echo json_encode(["state" => "success", "message" => "Submit successful!"]);

	} else {
    //http_response_code(405);
     echo json_encode(["state" => "error3", "message" => "Method not allowed."]);
    }
	
?> 
