<?php
include_once 'config-data.php';
?>
<div class="modal fade kt_modal_add" id="kt_modal_add_carousel" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
  <!--begin::Modal dialog-->
  <div class="modal-dialog modal-dialog-centered mw-650px">
 <!--begin::Modal content-->
 <div class="modal-content">
<!--begin::Form-->
<?php 
$CaId=(int)$_GET['p']; 
$result01=$conn->query("select * from carousel where CaId='$CaId'");
$field01 = $result01->fetch_assoc();
?>
<form action="pages/home-carousel-update.php" method="post" id="kt_modal_add_carousel_form" data-kt-redirect="home-carousel" class="form" enctype="multipart/form-data">
       <input type="hidden" value="<?php echo $field01['CaId']; ?>" name="CaId">
       <!--begin::Modal header-->
       <div class="modal-header" id="kt_modal_add_carousel_header">
              <!--begin::Modal title-->
              <h2 class="fw-bold">Edit a Carousel Image</h2>
              <!--end::Modal title-->
              <!--begin::Close-->
              <div id="kt_modal_add_carousel_close" class="btn btn-icon btn-sm btn-active-icon-primary">
                     <i class="ki-duotone ki-cross fs-1">
                            <span class="path1"></span>
                            <span class="path2"></span>
                     </i>
              </div>
              <!--end::Close-->
       </div>
       <!--end::Modal header-->
       <!--begin::Modal body-->
       <div class="modal-body py-10 px-lg-17">
              <!--begin::Scroll-->
              <div class="mh-375px scroll-y me-n7 pe-7">
                <?php
				$defaultCardPic = "assets/media/svg/avatars/blank.svg";
				if (!empty($field01['CaPic'])) {
				    $CardPic = "../media/carousel/" . $field01['CaPic']."?v=".time();
				} else {
				    $CardPic = $defaultCardPic;
				}
				?>
			    <!--begin::Thumbnail settings-->
				<div id="pxyz" class="card card-flush py-4 mb-5">
					<!--begin::Card header-->
					<div class="card-header">
						<!--begin::Card title-->
						<div class="card-title">
							<h4 class="required">Carousel Image</h4>
						</div>
						<!--end::Card title-->
					</div>
					<!--end::Card header-->
					<!--begin::Card body-->
					<div class="card-body text-center pt-0">
					<!--begin::Image input-->
				    <div class="image-input image-input-outline"
				         data-kt-image-input="true"
				         style="background-image: url('<?= $defaultCardPic ?>')">
				        <!--begin::Preview existing card image-->
				        <div class="image-input-wrapper w-250px h-140px"
				             style="background-image: url('<?= $CardPic ?>')">
				        </div>
				        <!--end::Preview existing card image-->

				        <!--begin::Label-->
                        <label class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="change" data-bs-toggle="tooltip" title="Change card image">
                           <i class="ki-duotone ki-pencil fs-7">
                              <span class="path1"></span>
                              <span class="path2"></span>
                           </i>
                           <!--begin::Inputs-->
                           <input type="file" name="CaImage" accept=".png, .jpg, .jpeg" id="CaImage" required="required" />
                           <input type="hidden" name="CaImage_remove" />
                           <!--end::Inputs-->
                        </label>
                        <!--end::Label-->
                        <input type="hidden" value="<?php echo $field01['CaPic'] ?>" name="ExistCaImage" />
				        <!--begin::Cancel-->
                        <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="cancel" data-bs-toggle="tooltip" title="Cancel card image">
                           <i class="ki-duotone ki-cross fs-2">
                              <span class="path1"></span>
                              <span class="path2"></span>
                           </i>
                        </span>
                        <!--end::Cancel-->
                        <!--begin::Remove-->
                        <span class="btn btn-icon btn-circle btn-active-color-primary w-25px h-25px bg-body shadow" data-kt-image-input-action="remove" data-bs-toggle="tooltip" title="Remove card image">
                           <i class="ki-duotone ki-cross fs-2">
                              <span class="path1"></span>
                              <span class="path2"></span>
                           </i>
                        </span>
                        <!--end::Remove-->
				    </div>
				    <!--end::Image input-->
					<!--begin::Description-->
					<div class="form-text fs-7 pt-2">Set the carousel  image. Only *.png, *.jpg and *.jpeg image files are accepted. Max. file size 1MB. Standard Dim: 1920px&#215;1080px</div>
					<!--end::Description-->
				</div>
				<!--end::Card body-->
			</div>
			<!--end::Thumbnail settings-->

              </div>
              <!--end::Scroll-->
       </div>
       <!--end::Modal body-->
       <!--begin::Modal footer-->
       <div class="modal-footer flex-center">
              <!--begin::Button-->
              <button type="reset" id="kt_modal_add_carousel_cancel" class="btn btn-light me-3">Discard</button>
              <!--end::Button-->
              <!--begin::Button-->
              <button type="submit" id="kt_modal_add_carousel_submit" class="btn btn-primary">
                     <span class="indicator-label">Update</span>
                     <span class="indicator-progress">Please wait... 
                     <span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
              </button>
              <!--end::Button-->
       </div>
       <!--end::Modal footer-->
</form>
<!--end::Form-->
</div>
  </div>
  <!--end::Modal dialog-->
</div>
<script type="text/javascript">
(function($){ 

"use strict";

// Class definition
var KTModalBrandAdd = function () {
    var submitButton;
    var cancelButton;
    var closeButton;
    var validator;
    var form;
    var modal;

    // Init form inputs
    var handleForm = function () {
        // Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/
              
              validator = FormValidation.formValidation();

              // Action buttons
              submitButton.addEventListener('click', function (e) {
                     e.preventDefault();


             if($('#CaImage').val()!=''){
                var file_size = $('#CaImage')[0].files[0].size;
                let file_type = $('#CaImage')[0].files[0].type;
                let valid_types = ["image/jpeg", "image/png", "image/gif"];
                /*1KB=1024*/
                if((file_size>1048576) || (!valid_types.includes(file_type))) {
                 let imgerror;
                 if(file_size>1048576){ imgerror="Image size is greater than 1MB.";}
                 else if(!valid_types.includes(file_type)){ imgerror="Invalid image type. Only JPG, JPEG, PNG, or GIF allowed.";}
                //alert("Picture size is greater than 1MB");
                Swal.fire({
                    text: "Sorry, "+imgerror,
                    icon: "error",
                    draggable: true,
                    buttonsStyling: !1,
                    confirmButtonText: "Ok, got it!",
                    customClass: {
                        confirmButton: "btn btn-primary"
                    }
                 }).then(function(t) {
                     setTimeout(function () {
                     const targetElement = document.querySelector("#pxyz");
                     targetElement.scrollIntoView({
                      behavior: 'smooth',
                      block: 'start'
                    });
                   }, 500);
                });
                return false;
                }
              }
                 // Validate form before submit
                 if (validator) {
                    validator.validate().then(function (status) {
                    //console.log('validated!');

                      if (status == 'Valid') {
                        submitButton.setAttribute('data-kt-indicator', 'on');

                        // Disable submit button whilst loading
                        submitButton.disabled = true;

                        //setTimeout(function() {
                        axios.post(submitButton.closest('form').getAttribute('action'), new FormData(form)).then(function(response) {

                            submitButton.removeAttribute('data-kt-indicator');
                            // Enable submit button after loading
                            submitButton.disabled = false;

                            //alert(response.data.state);
                            if (response.data.state === "success") {

    

                                Swal.fire({
                                        text: "Image has been successfully updated!",
                                        icon: "success",
                                        buttonsStyling: false,
                                        timer: 3000,
                                        confirmButtonText: "Ok, got it!",
                                        customClass: {
                                               confirmButton: "btn btn-primary"
                                        }
                                 }).then(function (result) {
                                        if (result.isConfirmed) {

                                        // Hide modal
                                        modal.hide();
                                        // Redirect to brand list page
                                        window.location = form.getAttribute("data-kt-redirect");
                                        }
                                 });
                            } else {
                                // Show error popup. For more info check the plugin's official documentation: https://sweetalert2.github.io/
                                let phperror;
                                if(response.data.state=="error1"){
                                  phperror="Unsupported image type! Only JPG, JPEG, PNG, or GIF allowed.";
                                } else if(response.data.state=="error2"){
                                  phperror="The code or name is exist, please try again.";
                                } else {
                                  phperror="Submit method not allowed.";  
                                }
                                Swal.fire({
                                    text: "Sorry, "+phperror,
                                    icon: "error",
                                    buttonsStyling: false,
                                    timer: 3000,
                                    confirmButtonText: "Ok, got it!",
                                    customClass: {
                                        confirmButton: "btn btn-primary"
                                    }
                                });
                            }
                        }).catch(function(error) {
                            Swal.fire({
                                text: "Sorry, looks like there are some errors detected, please try again.",
                                icon: "error",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-primary"
                                }
                            });
                        }).then(() => {
                            // Hide loading indication
                            submitButton.removeAttribute('data-kt-indicator');

                            // Enable button
                            submitButton.disabled = false;
                        });
                        //}, 2000);                         
                    } else {
                        Swal.fire({
                            text: "Sorry, looks like there are some errors detected, please try again.",
                            icon: "error",
                            buttonsStyling: false,
                            confirmButtonText: "Ok, got it!",
                            customClass: {
                                confirmButton: "btn btn-primary"
                            }
                        });
                    }

                         
                    });
                 }
              });

        cancelButton.addEventListener('click', function (e) {
            e.preventDefault();

            Swal.fire({
                text: "Are you sure you would like to cancel?",
                icon: "warning",
                showCancelButton: true,
                buttonsStyling: false,
                confirmButtonText: "Yes, cancel it!",
                cancelButtonText: "No, return",
                customClass: {
                    confirmButton: "btn btn-primary",
                    cancelButton: "btn btn-active-light"
                }
            }).then(function (result) {
              
                if (result.value) {
                     //$("#kt_modal_add_carousel").modal("hide");
                    form.reset(); // Reset form  
                    modal.hide(); // Hide modal                       
                } else if (result.dismiss === 'cancel') {
                    Swal.fire({
                        text: "Your form has not been cancelled!.",
                        icon: "error",
                        buttonsStyling: false,
                        timer: 2000,
                        confirmButtonText: "Ok, got it!",
                        customClass: {
                            confirmButton: "btn btn-primary",
                        }
                    });
                }
            });
        });

              closeButton.addEventListener('click', function(e){
                     e.preventDefault();

            Swal.fire({
                text: "Are you sure you would like to cancel?",
                icon: "warning",
                showCancelButton: true,
                buttonsStyling: false,
                confirmButtonText: "Yes, cancel it!",
                cancelButtonText: "No, return",
                customClass: {
                    confirmButton: "btn btn-primary",
                    cancelButton: "btn btn-active-light"
                }
            }).then(function (result) {
                if (result.value) {
                    form.reset(); // Reset form  
                    modal.hide(); // Hide modal                       
                } else if (result.dismiss === 'cancel') {
                    Swal.fire({
                        text: "Your form has not been cancelled!.",
                        icon: "error",
                        buttonsStyling: false,
                        timer: 2000,
                        confirmButtonText: "Ok, got it!",
                        customClass: {
                            confirmButton: "btn btn-primary",
                        }
                    });
                }
            });
              })
    }

    return {
        // Public functions
        init: function () {
            // Elements
            modal = new bootstrap.Modal(document.querySelector('#kt_modal_add_carousel'));

            form = document.querySelector('#kt_modal_add_carousel_form');
            submitButton = form.querySelector('#kt_modal_add_carousel_submit');
            cancelButton = form.querySelector('#kt_modal_add_carousel_cancel');
                     closeButton = form.querySelector('#kt_modal_add_carousel_close');

            handleForm();
            
        }
    };
}();

// On document ready
KTUtil.onDOMContentLoaded(function () {
       KTModalBrandAdd.init();
});    
})(jQuery);
</script>
