<link href="assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css"/>
 <!-- Modal HTML -->
 <div id="modality"></div>
<!--end::Modal - Category - Add-->
<div class="modal fade" id="imageModal" tabindex="-1" aria-labelledby="imageModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered mw-450px">
    <div class="modal-content">
      <div class="modal-body p-0">
        <img src="" alt="Preview" id="PreImg" class="img-fluid w-100">
      </div>
    </div>
  </div>
</div>
 <!-- Modal HTML -->
<!--begin::Content-->
<div id="kt_app_content" class="app-content flex-column-fluid">
	<!--begin::Content container-->
	<div id="kt_app_content_container" class="app-container container-xxl">
		<!--begin::Card-->
		<div class="card">
			<!--begin::Heading-->
			<div class="text-center mt-4">
				<!--begin::Title-->
				<h1 class="mt-2">Category List</h1>
				<!--end::Title-->
			</div>
			<!--end::Heading-->
			<!--begin::Card header-->
			<div class="card-header border-0 pt-2">
				<!--begin::Card title-->
				<div class="card-title">
					<!--begin::Search-->
					<div class="d-flex align-items-center position-relative my-1">
						<i class="ki-duotone ki-magnifier fs-3 position-absolute ms-5">
							<span class="path1"></span>
							<span class="path2"></span>
						</i>
						<input type="text" data-kt-filter="search" class="form-control form-control-solid w-250px ps-14" placeholder="Search Report" />
					</div>
					<!--end::Search-->
					<!--begin::Filter-->
					<div class="w-150px ms-3">
						<!--begin::Select2-->
						<select class="form-select form-select-solid" data-control="select2" data-hide-search="true" data-placeholder="Status" data-kt-filter="status">
							<option></option>
							<option value="all">All</option>
							<option value="Enabled">Enabled</option>
							<option value="Disabled">Disabled</option>
						</select>
						<!--end::Select2-->
					</div>
					<!--end::Filter-->
					<!--begin::Export buttons-->
					<div id="kt_datatable_category_1_export" class="d-none"></div>
					<!--end::Export buttons-->
				</div>
				<!--begin::Card title-->
				<!--begin::Card toolbar-->
				<div class="card-toolbar">
					<!--begin::Export dropdown-->
					<button type="button" class="btn btn-light-primary" data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">
						<i class="ki-duotone ki-exit-down fs-2"><span class="path1"></span><span class="path2"></span></i>
						Export Report
					</button>
					<!--begin::Menu-->
					<div id="kt_datatable_category_export_menu" class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-600 menu-state-bg-light-primary fw-semibold fs-7 w-200px py-4" data-kt-menu="true">
						<!--begin::Menu item-->
						<div class="menu-item px-3">
							<a href="#" class="menu-link px-3" data-kt-export="copy">
							Copy to clipboard
							</a>
						</div>
						<!--end::Menu item-->
						<!--begin::Menu item-->
						<div class="menu-item px-3">
							<a href="#" class="menu-link px-3" data-kt-export="excel">
							Export as Excel
							</a>
						</div>
						<!--end::Menu item-->
						<!--begin::Menu item-->
						<div class="menu-item px-3">
							<a href="#" class="menu-link px-3" data-kt-export="csv">
							Export as CSV
							</a>
						</div>
						<!--end::Menu item-->
						<!--begin::Menu item-->
						<div class="menu-item px-3">
							<a href="#" class="menu-link px-3" data-kt-export="pdf">
							Export as PDF
							</a>
						</div>
						<!--end::Menu item-->
						<!--begin::Menu item-->
						<div class="menu-item px-3">
							<a href="#" class="menu-link px-3" data-kt-export="print">
							Print Category List
							</a>
						</div>
						<!--end::Menu item-->
					</div>
					<!--end::Menu-->
					<!--end::Export dropdown-->

					<!--begin::Hide default export buttons-->
					<div id="kt_datatable_category_buttons" class="d-none"></div>
					<!--end::Hide default export buttons-->

					<!--begin::Add category-->
					<button type="button" class="btn btn-primary ms-3 view-modal" data-url="pages/category-add.php"><i class="bi bi-cloud-plus fs-3"></i> Add Category</button>
					<!--end::Add category-->
				</div>
				<!--end::Card toolbar-->
			</div>
			<!--end::Card header-->
			<!--begin::Card body-->
			<div class="card-body pt-0">
				<!--begin::Table-->
				<table class="table table-striped table-row-bordered align-middle gy-5 gs-7 border rounded" id="kt_datatable_category">
					<thead>
						<!--begin::Table row-->
						<tr class="text-start text-gray-500 fw-bold fs-7 text-uppercase">
							<th class="text-center">#</th>
							<th class="text-start min-w-100px">Code</th>
							<th class="min-w-150px">Name</th>
							<th class="min-w-150px">Description</th>
							<th class="min-w-100px">Parent</th>
							<th class="min-w-30px">Status</th>
							<th class="text-end min-w-70px">Actions</th>
						</tr>
						<!--end::Table row-->
					</thead>
					<tbody class="fw-semibold text-gray-600">
					<?php
				    $s=0;
				    $caStatus = array('1' =>'<div class="badge badge-light-success">Enabled</div>' , '2' =>'<div class="badge badge-light-danger">Disabled</div>');   
				    $result01=mysqli_query($con, "select * from mws_category order by CaStatus ASC, CaName ASC");
				    while($field01=mysqli_fetch_array($result01))
				    { $s++;

				      $SubCatQuery=mysqli_query($con,"select * from mws_category where CaId='$field01[CaIdParent]'");
                      $SubCatField=mysqli_fetch_array($SubCatQuery);
				    ?>
						<tr class="text-center">
							<td><?php echo $s ?></td>
							<td class="text-start pe-0"><?php echo $field01['CaCode'];?></td>
							<td class="text-start py-2 pe-0">
								<div class="d-flex align-items-center">
									<!--begin::Thumbnail-->
									<?php if(!is_null($field01['CaImage'])){ ?>
									<div data-url="../media/category/<?php echo $field01['CaImage'] ?>" class="symbol symbol-40px me-3 image-modal">
										<span class="symbol-label" style="background-image:url(../media/category/<?php echo $field01['CaImage'] ?>);"></span>
									</div>
								    <?php } ?>
									<!--end::Thumbnail-->
									<div data-kt-category-filter="category_name">
										<?php echo $field01['CaName'] ?>
									</div>
								</div>
							</td>
							<!-- <td class="text-start pe-0" data-kt-category-filter="category_name"><?php echo $field01['CaName'] ?></td> -->
							<td class="text-start pe-0"><?php echo $field01['CaDescription'] ?></td>
							<td class="text-start pe-0"><?php echo $SubCatField['CaName'] ?></td>
							<td class="text-start pe-0"><?php echo $caStatus[$field01['CaStatus']] ?></td>
							<td class="text-end py-2">
								<a href="#" class="btn btn-sm btn-light btn-flex btn-center btn-active-light-primary" data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">Actions 
								<i class="ki-duotone ki-down fs-5 ms-1"></i></a>
								<!--begin::Menu-->
								<div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-600 menu-state-bg-light-primary fw-semibold fs-7 w-125px py-2" data-kt-menu="true">
									<!--begin::Menu item-->
									<div class="menu-item px-2">
										<a href="#" class="menu-link px-3 py-1"><i class="bi bi-pencil-square"></i>&nbsp;Edit</a>
									</div>
									<!--end::Menu item-->
									<!--begin::Menu item-->
									<div class="menu-item px-2">
										<span class="menu-link px-3 py-1" data-ca-id="<?php echo $field01['CaId'] ?>"  data-ca-status="<?php echo $field01['CaStatus'] ?>" data-kt-category-filter="delete_row"><i class="bi bi-<?php if($field01['CaStatus']==2){ echo "recycle";}else {echo "trash3";} ?>"></i>&nbsp;<?php if($field01['CaStatus']==2){ echo "Restore";}else {echo "Delete";} ?></span>
									</div>
									<!--end::Menu item-->
								</div>
								<!--end::Menu-->
							</td>
						</tr>
					<?php } ?>
					</tbody>
				</table>
				<!--end::Table-->
			</div>
			<!--end::Card body-->
		</div>
		<!--end::Card-->
	</div>
	<!--end::Content container-->
</div>
<!--end::Content-->
<script src="assets/plugins/custom/datatables/datatables.bundle.js"></script>
<script src="assets/js/scripts.bundle-modal.js"></script>
<script>

$("input, textarea").on("paste", function() {
  $(this).val($.trim($(this).val()));
});
$("input, textarea").on("keypress", function(e) {
  var startPos = e.currentTarget.selectionStart;
  if (e.which === 32 && startPos==0)
    e.preventDefault();
});
$("input, textarea").on("blur", function(e) {
   $(this).val($.trim($(this).val()));
});

$('.view-modal').on('click', function () {
    $('#modality').load($(this).data("url"), function () {
      $('#kt_modal_add_category').modal('show');
      initModalScripts();
    });
 });
$(document).on('hidden.bs.modal', '#kt_modal_add_category', function () {
    initModalScripts();
});

$('.image-modal').on('click', function(e){
  e.preventDefault();
  $('#imageModal').modal('show');
  $('#imageModal .modal-content .modal-body #PreImg').attr('src',$(this).data("url"));
});

"use strict";

// Class definition
var KTDatatablesCategory = function () {
    // Shared variables
    var table;
    var datatable;

    // Private functions
    var initDatatable = function () {
        // Set date data order
        const tableRows = table.querySelectorAll('tbody tr');

        tableRows.forEach(row => {
            const dateRow = row.querySelectorAll('td');
            const realDate = moment(dateRow[3].innerHTML, "DD MMM YYYY, LT").format(); // select date from 4th column in table
            dateRow[3].setAttribute('data-order', realDate);
        });

        // Init datatable --- more info on datatables: https://datatables.net/manual/
        datatable = $(table).DataTable({
        	"lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
            /*"info": false,*//*Showing records*/
            'pageLength': 25,
            'order': [],
            'columnDefs': [{
					orderable: false,
					targets: -1
				}],
            responsive: true,
            rowReorder: true
            /*dom: 'Brtip',
            buttons: [
			  {
			    extend: 'colvis',
			    text: 'Columns',
			    className: 'btn btn-light-warning btn-sm'
			  }
			]*/
        });
    }

    // Hook export buttons
    var exportButtons = () => {
        const documentTitle = 'Category List';
        var buttons = new $.fn.dataTable.Buttons(table, {
             buttons: [
                {
                    extend: 'copyHtml5',
                    title: documentTitle,
                    exportOptions: {
				        columns: ':not(:last-child)' // Exclude last column
				    }
                },
                {
                    extend: 'excelHtml5',
                    title: documentTitle,
                    exportOptions: {
				        columns: ':not(:last-child)' // Exclude last column
				    }
                },
                {
                    extend: 'csvHtml5',
                    title: documentTitle,
                    exportOptions: {
				        columns: ':not(:last-child)' // Exclude last column
				    }
                },
                {
                    extend: 'pdfHtml5',
                    title: documentTitle,
                    exportOptions: {
				        columns: ':not(:last-child)' // Exclude last column
				    }
                },
                {
                    extend: 'print',
                    title: documentTitle,
                    exportOptions: {
				        columns: ':not(:last-child)' // Exclude last column
				    }
                }
            ]
        }).container().appendTo($('#kt_datatable_category_buttons'));

        // Hook dropdown menu click event to datatable export buttons
        const exportButtons = document.querySelectorAll('#kt_datatable_category_export_menu [data-kt-export]');
        exportButtons.forEach(exportButton => {
            exportButton.addEventListener('click', e => {
                e.preventDefault();

                // Get clicked export value
                const exportValue = e.target.getAttribute('data-kt-export');
                const target = document.querySelector('.dt-buttons .buttons-' + exportValue);

                // Trigger click event on hidden datatable export buttons
                target.click();
            });
        });
    }

    // Search Datatable --- official docs reference: https://datatables.net/reference/api/search()
    var handleSearchDatatable = () => {
        const filterSearch = document.querySelector('[data-kt-filter="search"]');
        filterSearch.addEventListener('keyup', function (e) {
            datatable.search(e.target.value).draw();
        });
    }
    
    var handleStatusFilter = () => {
        const filterStatus = document.querySelector('[data-kt-filter="status"]');

        $(filterStatus).on('change', e => {
            let value = e.target.value;

            // 6th column (index 5) contains the Status badge HTML
            if (value === 'all') {
                value = '';
            }
            
            // Using a regex search: '^value$' ensures an exact match of the content (Enabled/Disabled)
            // inside the 5th column's HTML.
            datatable.column(5).search(value ? '^' + value + '$' : '', true, false).draw();
            //datatable.column(4).search(value, true, false).draw();
        });
    }

    // Delete cateogry
    var handleDeleteRows = () => {
        
        var table = document.querySelector('#kt_datatable_category');
        // Select the static parent (the table body)
        const tbody = table.querySelector('tbody');

        $(tbody).on('click', '[data-kt-category-filter="delete_row"]', function (e) {
            e.preventDefault();

            // 'this' refers to the clicked element (the <span> with the attribute)
            const clickedElement = this; 
            // Select parent row (tr)
            const parent = clickedElement.closest('tr');

            // Get category name
            const caName = parent.querySelector('[data-kt-category-filter="category_name"]').innerText;

            const caid = clickedElement.getAttribute('data-ca-id');
            const castatus = clickedElement.getAttribute('data-ca-status');

            // SweetAlert2 pop up --- official docs reference: https://sweetalert2.github.io/
            const command = ["","delete","restore"];
            // ... rest of your Swal.fire and Axios logic remains the same ...

            Swal.fire({
                text: "Are you sure you want to "+ command[castatus] +" "+ caName + "?",
                icon: "warning",
                showCancelButton: true,
                buttonsStyling: false,
                confirmButtonText: "Yes, "+ command[castatus] +"!", // Corrected button text
                cancelButtonText: "No, cancel",
                customClass: {
                    confirmButton: "btn fw-bold btn-danger",
                    cancelButton: "btn fw-bold btn-active-light-primary"
                }
            }).then(function (result) {
                if (result.value) {

                    axios.get('pages/category-delete.php', {
                      params: {
                        id: caid,
                        status: castatus == 1 ? 2 : 1 // Logic to toggle status (e.g., Delete=2, Restore=1)
                      }
                    })
                    .then(response => {
                     //alert(response.data.status)
                      // 1. Update the status badge in the 5th column
                    const targetCaStatus = Number(response.data.status);
                    //alert(targetCaStatus);
					const statusCell = parent.cells[5];
					const newBadge = targetCaStatus === 1 
					  ? '<div class="badge badge-light-success">Enabled</div>' 
					  : '<div class="badge badge-light-danger">Disabled</div>';
					statusCell.innerHTML = newBadge;
                    
					// 2. Update the action button attributes (data-ca-status)
					clickedElement.setAttribute('data-ca-status', targetCaStatus);

					// 3. Update the action button text and icon
					const newIconClass = targetCaStatus === 1 ? "bi bi-trash3" : "bi bi-recycle";
					const newText = targetCaStatus === 1 ? "Delete" : "Restore";
					//alert(newText);
					clickedElement.innerHTML = `<i class="${newIconClass}"></i>&nbsp;${newText}`;

                      Swal.fire({
                            text: "The caegory " + caName + " has been " + (castatus == 1 ? "deleted" : "restored") + ".",
                            icon: "success",
                            buttonsStyling: false,
                            confirmButtonText: "Ok, got it!",
                            customClass: {
                                confirmButton: "btn fw-bold btn-primary",
                            }
                        }).then(function () {
                            // datatable.row($(parent)).remove().draw(); // This removes the row
                            // A safer way is to redraw the table to update all statuses/rows:
                            datatable.draw(false); // Redraws the table without changing the current page
                        });

                    })
                    .catch(error => {
                      //console.error(error);
                      Swal.fire({
                          text: "An error occurred while processing your request.",
                          icon: "error",
                          buttonsStyling: false,
                          confirmButtonText: "Ok, got it!",
                          customClass: {
                              confirmButton: "btn fw-bold btn-primary",
                          }
                      });
                    });

                } else if (result.dismiss === 'cancel') {
                    Swal.fire({
                        text: caName + " was not " + command[castatus] + ".",
                        icon: "error",
                        buttonsStyling: false,
                        confirmButtonText: "Ok, got it!",
                        customClass: {
                            confirmButton: "btn fw-bold btn-primary",
                        }
                    });
                }
            });
        });
        
    }
    
    
    // Public methods
    return {
        init: function () {
            table = document.querySelector('#kt_datatable_category');

            if ( !table ) {
                return;
            }

            initDatatable();
            exportButtons();
            handleSearchDatatable();
            handleStatusFilter();
            handleDeleteRows();
        }
    };
}();

// On document ready
KTUtil.onDOMContentLoaded(function () {
    KTDatatablesCategory.init();
});

</script>
