<link href="assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css"/>
 <!-- Modal HTML -->
  <div id="modality"></div>
  <!-- Modal HTML -->
<!--begin::Content-->
<div id="kt_app_content" class="app-content flex-column-fluid">
	
	<!--begin::Content container-->
	<div id="kt_app_content_container" class="app-container container-xxl">
		<!--begin::Card-->
		<div class="card">
			<!--begin::Heading-->
			<div class="text-center mt-4">
				<!--begin::Title-->
				<h1 class="mt-2">Admission List</h1>
				<!--end::Title-->
			</div>
			<!--end::Heading-->
			<!--begin::Card header-->
			<div class="card-header border-0 pt-2">
				<!--begin::Card title-->
				<div class="card-title">
					<!--begin::Search-->
					<div class="d-flex align-items-center position-relative my-1">
						<i class="ki-duotone ki-magnifier fs-3 position-absolute ms-5">
							<span class="path1"></span>
							<span class="path2"></span>
						</i>
						<input type="text" data-kt-filter="search" class="form-control form-control-solid w-250px ps-14" placeholder="Search Report" />
					</div>
					<!--end::Search-->
					<!--begin::Export buttons-->
					<div id="kt_datatable_branch_1_export" class="d-none"></div>
					<!--end::Export buttons-->
				</div>
				<!--begin::Card title-->
				<!--begin::Card toolbar-->
				<div class="card-toolbar">
					<!--begin::Export dropdown-->
					<button type="button" class="btn btn-light-primary" data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">
						<i class="ki-duotone ki-exit-down fs-2"><span class="path1"></span><span class="path2"></span></i>
						Export Report
					</button>
					<!--begin::Menu-->
					<div id="kt_datatable_branch_export_menu" class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-600 menu-state-bg-light-primary fw-semibold fs-7 w-200px py-4" data-kt-menu="true">
						<!--begin::Menu item-->
						<div class="menu-item px-3">
							<a href="#" class="menu-link px-3" data-kt-export="copy">
							Copy to clipboard
							</a>
						</div>
						<!--end::Menu item-->
						<!--begin::Menu item-->
						<div class="menu-item px-3">
							<a href="#" class="menu-link px-3" data-kt-export="excel">
							Export as Excel
							</a>
						</div>
						<!--end::Menu item-->
						<!--begin::Menu item-->
						<div class="menu-item px-3">
							<a href="#" class="menu-link px-3" data-kt-export="csv">
							Export as CSV
							</a>
						</div>
						<!--end::Menu item-->
						<!--begin::Menu item-->
						<div class="menu-item px-3">
							<a href="#" class="menu-link px-3" data-kt-export="pdf">
							Export as PDF
							</a>
						</div>
						<!--end::Menu item-->
					</div>
					<!--end::Menu-->
					<!--end::Export dropdown-->

					<!--begin::Hide default export buttons-->
					<div id="kt_datatable_branch_buttons" class="d-none"></div>
					<!--end::Hide default export buttons-->
				</div>
				<!--end::Card toolbar-->
			</div>
			<!--end::Card header-->
			<!--begin::Card body-->
			<div class="card-body pt-0">
				<!--begin::Table-->
				<table class="table table-striped table-row-bordered align-middle gy-5 gs-7 border rounded" id="kt_datatable_branch">
					<thead>
						<!--begin::Table row-->
						<tr class="text-start text-gray-500 fw-bold fs-7 text-uppercase">
							<th class="text-center">#</th>
							<th class="text-start min-w-80px">ID</th>
							<th class="text-start min-w-180px">Name</th>
							<th class="text-start min-w-100px">Mobile</th>
							<th class="text-start min-w-60px">Gender</th>
							<th class="text-start min-w-180px">Branch</th>
							<th class="min-w-30px">Status</th>
							<th class="text-center min-w-60px">Actions</th>
						</tr>
						<!--end::Table row-->
					</thead>
					<tbody class="fw-semibold text-gray-600">
					<?php
					$caStatus = array('1' =>'<div class="badge badge-light-success">Enabled</div>' , '2' =>'<div class="badge badge-light-danger">Disabled</div>');
					$genders = [
					    1 => 'Male',
					    2 => 'Female'
					];
				    $s=0;  
				    $result01=$conn->query("select * from student as a inner join branch as b on a.BrId=b.BrId order by a.StId DESC");
					while ($field01 = $result01->fetch_assoc()) { 
				    $s++;
				    ?>
						<tr class="text-center">
							<td><?php echo $s ?></td>
							<td class="text-start pe-0">
								<span data-url="pages/admission-details.php?p=<?php echo $field01['StId'] ?>" class="text-gray-900 text-hover-primary view-modal"><?php echo $field01['StCode'];?></span>
							</td>
							<td class="text-start py-2 pe-0">
								<div class="d-flex align-items-center">
									<!--begin::Thumbnail-->
									<?php if(!is_null($field01['StPic'])){ ?>
									<div data-url="../media/student/<?php echo $field01['StPic'] ?>" class="symbol symbol-40px me-3 image-modal">
										<span class="symbol-label" style="background-image:url(../media/student/<?php echo $field01['StPic'] ?>);"></span>
									</div>
								    <?php } ?>
									<!--end::Thumbnail-->
									<div data-kt-category-filter="category_name">
										<?php echo $field01['StName'] ?>
									</div>
								</div>
							</td>
							<td class="text-start pe-0"><?php echo $field01['StMobile'] ?></td>
							<td class="text-start pe-0"><?php echo $genders[$field01['StGender']] ?></td>
							<td class="text-start pe-0"><?php echo $field01['BrName'] ?></td>
							<td class="text-start pe-0"><?php echo $caStatus[$field01['StStatus']] ?></td>
							<td class="text-center py-2">
								<a href="#" class="btn btn-sm btn-light btn-flex btn-center btn-active-light-primary" data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">Actions 
								<i class="ki-duotone ki-down fs-5 ms-1"></i></a>
								<!--begin::Menu-->
								<div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-600 menu-state-bg-light-primary fw-semibold fs-7 w-125px py-2" data-kt-menu="true">
									<!--begin::Menu item-->
									<div class="menu-item px-2">
										<span data-url="pages/admission-details.php?p=<?php echo $field01['StId'] ?>" class="menu-link px-3 py-1 text-hover-primary view-modal"><i class="bi bi-eye"></i>&nbsp;View</span>
									</div>
									<!--end::Menu item-->
									<!--begin::Menu item-->
									<div class="menu-item px-2">
										<a href="<?php echo $loc ?>/admission-edit/<?php echo $field01['StId'] ?>" target="_blank" class="menu-link px-3 py-1 text-hover-primary"><i class="bi bi-pencil-square"></i>&nbsp;Edit</a>
									</div>
									<!--end::Menu item-->
									<!--begin::Menu item-->
									<!-- <div class="menu-item px-2">
										<span class="menu-link px-3 py-1 text-hover-primary" data-pr-id="<?php echo $field01['StId'] ?>" data-kt-branch-filter="delete_row"><i class="bi bi-trash3"></i>&nbsp;Delete</span>
									</div> -->
									<!--end::Menu item-->
								</div>
								<!--end::Menu-->
							</td>
						</tr>
					<?php } ?>
					</tbody>
				</table>
				<!--end::Table-->
			</div>
			<!--end::Card body-->
		</div>
		<!--end::Card-->
	</div>
	<!--end::Content container-->
</div>
<!--end::Content-->
<script src="assets/js/scripts.bundle-modal.js"></script>
<script src="assets/plugins/custom/datatables/datatables.bundle.js"></script>
<script>
$("input, textarea").on("paste", function() {
  $(this).val($.trim($(this).val()));
});
$("input, textarea").on("keypress", function(e) {
  var startPos = e.currentTarget.selectionStart;
  if (e.which === 32 && startPos==0)
    e.preventDefault();
});
$("input, textarea").on("blur", function(e) {
   $(this).val($.trim($(this).val()));
});

<?php 
if(isset($_SESSION['bsms']))
{
 $mno=$_SESSION['bsms'];
?>
const mess = ["","Admission has been successfully updated!"];
const micon = ["","success"];
const mbtn = ["","success"];
// Show popup confirmation
Swal.fire({
    text: mess[<?php echo $mno ?>],
    icon: micon[<?php echo $mno ?>],
    draggable: true,
    buttonsStyling: false,
    timer: 3000,
    confirmButtonText: "Ok, got it!",
    customClass: {
        confirmButton: "btn btn-"+mbtn[<?php echo $mno ?>]
    }
});
<?php unset($_SESSION['bsms']); } ?>

$('.view-modal').on('click', function () {
    $('#modality').load($(this).data("url"), function () {
      $('.kt_modal_add').modal('show');
      initModalScripts();
    });
 });
$(document).on('hidden.bs.modal', '.kt_modal_add', function () {
    initModalScripts();
});

"use strict";

// Class definition
var KTDatatablesProduct = function () {
    // Shared variables
    var table;
    var datatable;

    // Private functions
    var initDatatable = function () {
        // Set date data order
        const tableRows = table.querySelectorAll('tbody tr');

        // Init datatable --- more info on datatables: https://datatables.net/manual/
        datatable = $(table).DataTable({
        	"lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
            /*"info": false,*//*Showing records*/
            'pageLength': 25,
            'order': [],
            'columnDefs': [{
					orderable: false,
					targets: -1
				}],
            responsive: true,
            rowReorder: true
            /*dom: 'Brtip',
            buttons: [
			  {
			    extend: 'colvis',
			    text: 'Columns',
			    className: 'btn btn-light-warning btn-sm'
			  }
			]*/
        });
    }

    // Hook export buttons
    var exportButtons = () => {
        const documentTitle = 'Admission List';
        var buttons = new $.fn.dataTable.Buttons(table, {
            buttons: [
                {
                    extend: 'copyHtml5',
                    title: documentTitle,
                    exportOptions: {
				        columns: ':not(:last-child)' // Exclude last column
				    }
                },
                {
                    extend: 'excelHtml5',
                    title: documentTitle,
                    exportOptions: {
				        columns: ':not(:last-child)' // Exclude last column
				    }
                },
                {
                    extend: 'csvHtml5',
                    title: documentTitle,
                    exportOptions: {
				        columns: ':not(:last-child)' // Exclude last column
				    }
                },
                {
                    extend: 'pdfHtml5',
                    title: documentTitle,
                    exportOptions: {
				        columns: ':not(:last-child)' // Exclude last column
				    }
                },
                {
                    extend: 'print',
                    title: documentTitle,
                    exportOptions: {
				        columns: ':not(:last-child)' // Exclude last column
				    }
                }
            ]
        }).container().appendTo($('#kt_datatable_branch_buttons'));

        // Hook dropdown menu click event to datatable export buttons
        const exportButtons = document.querySelectorAll('#kt_datatable_branch_export_menu [data-kt-export]');
        exportButtons.forEach(exportButton => {
            exportButton.addEventListener('click', e => {
                e.preventDefault();

                // Get clicked export value
                const exportValue = e.target.getAttribute('data-kt-export');
                const target = document.querySelector('.dt-buttons .buttons-' + exportValue);

                // Trigger click event on hidden datatable export buttons
                target.click();
            });
        });
    }

    // Search Datatable --- official docs reference: https://datatables.net/reference/api/search()
    var handleSearchDatatable = () => {
        const filterSearch = document.querySelector('[data-kt-filter="search"]');
        filterSearch.addEventListener('keyup', function (e) {
            datatable.search(e.target.value).draw();
        });
    }

    // Public methods
    return {
        init: function () {
            table = document.querySelector('#kt_datatable_branch');

            if ( !table ) {
                return;
            }

            initDatatable();
            exportButtons();
            handleSearchDatatable();
        }
    };
}();

// On document ready
KTUtil.onDOMContentLoaded(function () {
    KTDatatablesProduct.init();
});

</script>
