<link href="assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css"/>
<!-- Modal HTML -->
<div id="modality"></div>
<!-- Modal HTML -->
<!--begin::Content-->
<div id="kt_app_content" class="app-content flex-column-fluid">
	<!--begin::Content container-->
	<div id="kt_app_content_container" class="app-container container-xxl">
		<!--begin::Card-->
		<div class="card">
			<!--begin::Heading-->
			<div class="text-center mt-4">
				<!--begin::Title-->
				<h1 class="mt-2">POS Return List</h1>
				<!--end::Title-->
			</div>
			<!--end::Heading-->
			<!--begin::Card header-->
			<div class="card-header border-0 pt-2">
				<!--begin::Card title-->
				<div class="card-title">
					<!--begin::Search-->
					<div class="d-flex align-items-center position-relative my-1">
						<i class="ki-duotone ki-magnifier fs-3 position-absolute ms-5">
							<span class="path1"></span>
							<span class="path2"></span>
						</i>
						<input type="text" data-kt-filter="search" class="form-control form-control-solid w-250px ps-14" placeholder="Search Report" />
					</div>
					<!--end::Search-->
					<!--begin::Export buttons-->
					<div id="kt_datatable_pos_1_export" class="d-none"></div>
					<!--end::Export buttons-->
				</div>
				<!--begin::Card title-->
				<!--begin::Card toolbar-->
				<div class="card-toolbar">
					<!--begin::Export dropdown-->
					<button type="button" class="btn btn-light-primary" data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">
						<i class="ki-duotone ki-exit-down fs-2"><span class="path1"></span><span class="path2"></span></i>
						Export Report
					</button>
					<!--begin::Menu-->
					<div id="kt_datatable_pos_export_menu" class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-600 menu-state-bg-light-primary fw-semibold fs-7 w-200px py-4" data-kt-menu="true">
						<!--begin::Menu item-->
						<div class="menu-item px-3">
							<a href="#" class="menu-link px-3" data-kt-export="copy">
							Copy to Clipboard
							</a>
						</div>
						<!--end::Menu item-->
						<!--begin::Menu item-->
						<div class="menu-item px-3">
							<a href="#" class="menu-link px-3" data-kt-export="excel">
							Export as Excel
							</a>
						</div>
						<!--end::Menu item-->
						<!--begin::Menu item-->
						<div class="menu-item px-3">
							<a href="#" class="menu-link px-3" data-kt-export="csv">
							Export as CSV
							</a>
						</div>
						<!--end::Menu item-->
						<!--begin::Menu item-->
						<div class="menu-item px-3">
							<a href="#" class="menu-link px-3" data-kt-export="pdf">
							Export as PDF
							</a>
						</div>
						<!--end::Menu item-->
						<!--begin::Menu item-->
						<div class="menu-item px-3">
							<a href="#" class="menu-link px-3" data-kt-export="print">
							Print POS Return List
							</a>
						</div>
						<!--end::Menu item-->
					</div>
					<!--end::Menu-->
					<!--end::Export dropdown-->

					<!--begin::Hide default export buttons-->
					<div id="kt_datatable_pos_buttons" class="d-none"></div>
					<!--end::Hide default export buttons-->
				</div>
				<!--end::Card toolbar-->
			</div>
			<!--end::Card header-->
			<!--begin::Card body-->
			<div class="card-body pt-0">
				<!--begin::Table-->
				<table class="table table-striped table-row-bordered align-middle gy-5 gs-7 border rounded" id="kt_datatable_pos">
					<thead>
						<!--begin::Table row-->
						<tr class="text-start text-gray-500 fw-bold fs-7 text-uppercase">
							<th class="text-center">#</th>
							<th class="min-w-120px">Date</th>
							<th class="text-start min-w-115px">Invoice</th>
							<th class="min-w-115px">POS Invoice</th>
							<th class="min-w-100px">Warehouse</th>
							<th class="min-w-100px">Customer</th>
							<th class="min-w-100px text-end ">Total</th>
							<th class="text-end min-w-70px">Actions</th>
						</tr>
						<!--end::Table row-->
					</thead>
					<tbody class="fw-semibold text-gray-600">
					<?php
				    $s=0;
				    $result01=mysqli_query($con, "select * from mws_posret as a inner join mws_pos as b on a.PoId=b.PoId inner join mws_warehouse as c on b.WhId=c.WhId left join mws_customer as d on b.CuId=d.CuId where a.PorStatus=1 order by a.PorDate DESC");
				    while($field01=mysqli_fetch_array($result01))
				    { $s++;

				    if (!empty($field01['PorDisType']) and !empty($field01['PorDisc'])) { 
						if ($field01['PorDisType'] == 1) {
						  $DiscountAmount = number_format($field01['PorDisc'],2, '.', '');
						} else if ($field01['PorDisType'] == 2) {
						  $DiscountAmount = number_format((($field01['PorGrandTotal'] * $field01['PorDisc']) / 100),2, '.', '');
						}
						$NetTotal=number_format(($field01['PorGrandTotal']-$DiscountAmount),2, '.', '');
				    } else {
				    	$NetTotal=number_format($field01['PorGrandTotal'],2, '.', '');
				    }
				    ?>
						<tr class="text-center">
							<td><?php echo $s ?></td>
							<td class="text-start pe-0" data-order="<?php echo $field01['PoDate']; ?>"><?php echo date("m/d/Y, g:i A", strtotime($field01['PorDate'])); ?></td>
							<td class="text-start pe-0" data-kt-pos-filter="pos_name">
								<span data-url="pages/pos-return-details.php?p=<?php echo $field01['PorId'] ?>" class="text-gray-900 text-hover-primary view-modal"><?php echo $field01['PorInv'];?></span>
							</td>
							<td class="text-start pe-0" data-kt-pos-filter="pos_name">
								<span data-url="pages/pos-details.php?p=<?php echo $field01['PoId'] ?>" class="text-gray-900 text-hover-primary view-modal"><?php echo $field01['PoInvoice'];?></span>
							</td>
							<td class="text-start pe-0"><?php echo $field01['WhName'] ?></td>
							<td class="text-start pe-0"><?php echo $field01['CuCompany'] ?></td>
							<td class="text-end pe-0"><?php echo $NetTotal ?></td>
							<td class="text-end py-2">
								<a href="#" class="btn btn-sm btn-light btn-flex btn-center btn-active-light-primary" data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">Actions 
								<i class="ki-duotone ki-down fs-5 ms-1"></i></a>
								<!--begin::Menu-->
								<div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-600 menu-state-bg-light-primary fw-semibold fs-7 w-125px py-2" data-kt-menu="true">
									<!--begin::Menu item-->
									<div class="menu-item px-2">
										<span data-url="pages/pos-return-details.php?p=<?php echo $field01['PorId'] ?>" class="menu-link px-3 py-1 text-hover-primary view-modal"><i class="bi bi-eye"></i>&nbsp;View</span>
									</div>
									<!--end::Menu item-->
									<!--begin::Menu item-->
									<div class="menu-item px-2">
										<a href="<?php echo $loc ?>/pos-return/<?php echo $field01['PoId'] ?>" class="menu-link px-3 py-1 text-hover-primary"><i class="bi bi-pencil-square"></i>&nbsp;Edit</a>
									</div>
									<!--end::Menu item-->
									<!--begin::Menu item-->
									<div class="menu-item px-2">
										<a href="#" class="menu-link px-3 py-1" data-sa-id="<?php echo $field01['PoId'] ?>" data-kt-pos-filter="delete_row"><i class="bi bi-trash3"></i>&nbsp;Delete</a>
									</div>
									<!--end::Menu item-->
								</div>
								<!--end::Menu-->
							</td>
						</tr>
					<?php } ?>
					</tbody>
				</table>
				<!--end::Table-->
			</div>
			<!--end::Card body-->
		</div>
		<!--end::Card-->
	</div>
	<!--end::Content container-->
</div>
<!--end::Content-->
<script src="assets/js/scripts.bundle-modal.js"></script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr/dist/plugins/confirmDate/confirmDate.js"></script>
<script src="assets/plugins/custom/datatables/datatables.bundle.js"></script>
<script>
$("input, textarea").on("paste", function() {
  $(this).val($.trim($(this).val()));
});
$("input, textarea").on("keypress", function(e) {
  var startPos = e.currentTarget.selectionStart;
  if (e.which === 32 && startPos==0)
    e.preventDefault();
});
$("input, textarea").on("blur", function(e) {
   $(this).val($.trim($(this).val()));
});

<?php 
if(isset($_SESSION['pslsms']))
{
 $mno=$_SESSION['pslsms'];
?>
const mess = ["","POS return has been successfully updated!"];
const micon = ["","success"];
const mbtn = ["","success"];
// Show popup confirmation
Swal.fire({
    text: mess[<?php echo $mno ?>],
    icon: micon[<?php echo $mno ?>],
    draggable: true,
    buttonsStyling: false,
    timer: 3000,
    confirmButtonText: "Ok, got it!",
    customClass: {
        confirmButton: "btn btn-"+mbtn[<?php echo $mno ?>]
    }
});
<?php unset($_SESSION['pslsms']); } ?>

$('.view-modal').on('click', function () {
    $('#modality').load($(this).data("url"), function () {
      $('.kt_modal_add').modal('show');
      initModalScripts();
    });
 });
$(document).on('hidden.bs.modal', '.kt_modal_add', function () {
    initModalScripts();
});

"use strict";

// Class definition
var KTDatatablesPOS = function () {
    // Shared variables
    var table;
    var datatable;

    // Private functions
    var initDatatable = function () {
        // Set date data order
        const tableRows = table.querySelectorAll('tbody tr');

        tableRows.forEach(row => {
            const dateRow = row.querySelectorAll('td');
            const realDate = moment(dateRow[1].innerHTML, "MM/DD/YYYY, LT").format(); // select date from 2nd column in table
            dateRow[1].setAttribute('data-order', realDate);
        });

        // Init datatable --- more info on datatables: https://datatables.net/manual/
        datatable = $(table).DataTable({
        	"lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
            /*"info": false,*//*Showing records*/
            'pageLength': 25,
            'order': [],
            'columnDefs': [{
					orderable: false,
					targets: -1
				}],
            responsive: true,
            rowReorder: true
            /*dom: 'Brtip',
            buttons: [
			  {
			    extend: 'colvis',
			    text: 'Columns',
			    className: 'btn btn-light-warning btn-sm'
			  }
			]*/
        });
    }

    // Hook export buttons
    var exportButtons = () => {
        const documentTitle = 'POS Return List';
        var buttons = new $.fn.dataTable.Buttons(table, {
            buttons: [
                {
                    extend: 'copyHtml5',
                    title: documentTitle,
                    exportOptions: {
				        columns: ':not(:last-child)' // Exclude last column
				    }
                },
                {
                    extend: 'excelHtml5',
                    title: documentTitle,
                    exportOptions: {
				        columns: ':not(:last-child)' // Exclude last column
				    }
                },
                {
                    extend: 'csvHtml5',
                    title: documentTitle,
                    exportOptions: {
				        columns: ':not(:last-child)' // Exclude last column
				    }
                },
                {
                    extend: 'pdfHtml5',
                    title: documentTitle,
                    exportOptions: {
				        columns: ':not(:last-child)' // Exclude last column
				    }
                },
                {
                    extend: 'print',
                    title: documentTitle,
                    exportOptions: {
				        columns: ':not(:last-child)' // Exclude last column
				    }
                }
            ]
        }).container().appendTo($('#kt_datatable_pos_buttons'));

        // Hook dropdown menu click event to datatable export buttons
        const exportButtons = document.querySelectorAll('#kt_datatable_pos_export_menu [data-kt-export]');
        exportButtons.forEach(exportButton => {
            exportButton.addEventListener('click', e => {
                e.preventDefault();

                // Get clicked export value
                const exportValue = e.target.getAttribute('data-kt-export');
                const target = document.querySelector('.dt-buttons .buttons-' + exportValue);

                // Trigger click event on hidden datatable export buttons
                target.click();
            });
        });
    }

    // Search Datatable --- official docs reference: https://datatables.net/reference/api/search()
    var handleSearchDatatable = () => {
        const filterSearch = document.querySelector('[data-kt-filter="search"]');
        filterSearch.addEventListener('keyup', function (e) {
            datatable.search(e.target.value).draw();
        });
    }


    // Delete cateogry
    var handleDeleteRows = () => {
    	// Select all delete buttons
        const deleteButtons = table.querySelectorAll('[data-kt-pos-filter="delete_row"]');
        deleteButtons.forEach(d => {
            // Delete button on click
            d.addEventListener('click', function (e) {
                e.preventDefault();
                // Select parent row
                const parent = e.target.closest('tr');

                // Get category name
                const posName = parent.querySelector('[data-kt-pos-filter="pos_name"]').innerText;

                const said = this.getAttribute('data-sa-id');

                // SweetAlert2 pop up --- official docs reference: https://sweetalert2.github.io/
                Swal.fire({
                    text: "Are you sure you want to delete " + posName + "?",
                    icon: "warning",
                    showCancelButton: true,
                    buttonsStyling: false,
                    confirmButtonText: "Yes, delete!",
                    cancelButtonText: "No, cancel",
                    customClass: {
                        confirmButton: "btn fw-bold btn-danger",
                        cancelButton: "btn fw-bold btn-active-light-primary"
                    }
                }).then(function (result) {
                    if (result.value) {

                        axios.get('pages/posret-delete+.php', {
						  params: {
						    id: said,
						    status: 1
						  }
						})
						.then(response => {
						  //console.log(response.data);
						  //alert(response.data.state);
						  Swal.fire({
	                            text: "You have deleted " + posName + "!.",
	                            icon: "success",
	                            buttonsStyling: false,
	                            confirmButtonText: "Ok, got it!",
	                            customClass: {
	                                confirmButton: "btn fw-bold btn-primary",
	                            }
	                        }).then(function () {
	                            // Remove current row
	                            datatable.row($(parent)).remove().draw();
	                        });

						})
						.catch(error => {
						  //console.error(error);
						});

                    } else if (result.dismiss === 'cancel') {
                        Swal.fire({
                            text: posName + " was not deleted.",
                            icon: "error",
                            buttonsStyling: false,
                            confirmButtonText: "Ok, got it!",
                            customClass: {
                                confirmButton: "btn fw-bold btn-primary",
                            }
                        });
                    }
                });
            })
        });
    }

    // Public methods
    return {
        init: function () {
            table = document.querySelector('#kt_datatable_pos');

            if ( !table ) {
                return;
            }

            initDatatable();
            exportButtons();
            handleSearchDatatable();
            handleDeleteRows();
        }
    };
}();

// On document ready
KTUtil.onDOMContentLoaded(function () {
    KTDatatablesPOS.init();
});

</script>
