<?php
	include_once 'config-data.php';
	header("Content-Type: application/json");

	if ($_SERVER['REQUEST_METHOD'] === 'POST') {

      // 1. CSRF Verification
		if (!isset($_POST['token']) || $_POST['token'] !== $_SESSION['token']) {
		    exit(json_encode(['state' => 'error', 'message' => 'Form token mismatch']));
		}

      $old_pass = $_POST['CurrentPassword'];
		$new_pass = $_POST['NewPassword'];
		$con_pass = $_POST['ConfirmPassword'];

		if ($old_pass === $new_pass) {
		    exit(json_encode([
		        'state' => 'error', 
		        'message' => 'New password must be different from the current password.'
		    ]));
		}

		// 2. Basic Validations
		if ($new_pass !== $con_pass) {
		    exit(json_encode(['state' => 'error', 'message' => 'New passwords do not match']));
		}

		$pass_length = strlen($new_pass);

		if ($pass_length < 6 || $pass_length > 8) {
		    exit(json_encode([
		        'state' => 'error', 
		        'message' => 'Security policy: Password must be 6 to 12 characters.'
		    ]));
		}

		// 3. Fetch current hashed password from DB
		$stmt = $conn->prepare("SELECT StPassword FROM student WHERE StId = ? LIMIT 1");
		$stmt->bind_param("i", $UserId);
		$stmt->execute();
		$stmt->bind_result($hashed_password);
		$stmt->fetch();
		$stmt->close();

		// 4. Verify Old Password
		// Note: This assumes you used password_hash() when the user registered
		if (!password_verify($old_pass, $hashed_password)) {
		    exit(json_encode(['state' => 'error', 'message' => 'Current password is incorrect']));
		}

		// 5. Update to New Password
		$new_hashed_password = password_hash($new_pass, PASSWORD_DEFAULT);
		$update = $conn->prepare("UPDATE student SET StPassword = ? WHERE StId = ?");
		$update->bind_param("si", $new_hashed_password, $UserId);

		if ($update->execute()) {
		    echo json_encode(['state' => 'success', 'message' => 'Password updated successfully!']);
		} else {
		    echo json_encode(['state' => 'error', 'message' => 'Database error. Try again later.']);
		}
		$update->close();

		/*echo json_encode(["state" => "success", "message" => "Submit successful!"]);*/


	} else {
    //http_response_code(405);
     echo json_encode(["state" => "error", "message" => "Method not allowed."]);
    }
	
?> 
